/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.AlluxioFileInStream;
import alluxio.client.file.AlluxioFileOutStream;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemContextReinitializer;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.ListStatusPartialResult;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.InStreamOptions;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.ConfigurationBuilder;
import alluxio.conf.OverlayConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.AlreadyExistsException;
import alluxio.exception.status.FailedPreconditionException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.Bits;
import alluxio.grpc.CancelSyncMetadataPResponse;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GetSyncProgressPResponse;
import alluxio.grpc.JobProgressReportFormat;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPartialPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.SyncMetadataAsyncPResponse;
import alluxio.grpc.SyncMetadataPOptions;
import alluxio.grpc.SyncMetadataPResponse;
import alluxio.grpc.UnmountPOptions;
import alluxio.job.JobDescription;
import alluxio.job.JobRequest;
import alluxio.master.MasterInquireClient;
import alluxio.resource.CloseableResource;
import alluxio.security.authorization.AclEntry;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.com.google.common.net.HostAndPort;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.uri.Authority;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.wire.BlockLocation;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BaseFileSystem
implements FileSystem {
    private static final AlluxioConfiguration DIRECT_ACCESS_CONF = new ConfigurationBuilder().setProperty(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, "0").setProperty(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, (Object)ReadType.NO_CACHE).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.THROUGH).build();
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileSystem.class);
    private final Closer mCloser = Closer.create();
    protected final FileSystemContext mFsContext;
    protected final BlockStoreClient mBlockStore;
    protected AtomicReference<Matcher> mPathRegex = new AtomicReference();
    protected volatile boolean mClosed = false;
    protected static final Error UNREACHABLE_CODE_ERROR = new Error("We should never reach here. wrapAndThrowAlluxioStatusException is guaranteed to throw an exception and never returns.");

    public BaseFileSystem(FileSystemContext fsContext) {
        this.mFsContext = fsContext;
        this.mBlockStore = BlockStoreClient.create(fsContext);
        this.mCloser.register(this.mFsContext);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
        }
        this.mCloser.close();
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void checkAccess(AlluxioURI path, CheckAccessPOptions options) throws InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            CheckAccessPOptions mergedOptions = FileSystemOptionsUtils.checkAccessDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.checkAccess(path, mergedOptions);
            LOG.debug("Checked access {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    private boolean checkDirectAccess(AlluxioURI uri) {
        if (!this.getConf().isSet(PropertyKey.USER_FILE_DIRECT_ACCESS)) {
            return false;
        }
        if (this.mPathRegex.get() == null) {
            this.mPathRegex.compareAndSet(null, Pattern.compile(this.getConf().getString(PropertyKey.USER_FILE_DIRECT_ACCESS)).matcher(""));
        }
        return this.mPathRegex.get().reset(uri.getPath()).matches();
    }

    private AlluxioConfiguration getDirectAccessConf(AlluxioURI uri) {
        AlluxioConfiguration inner = this.mFsContext.getPathConf(uri);
        if (this.checkDirectAccess(uri)) {
            return new OverlayConfiguration(DIRECT_ACCESS_CONF, inner);
        }
        return inner;
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            CreateDirectoryPOptions mergedOptions = FileSystemOptionsUtils.createDirectoryDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.createDirectory(path, mergedOptions);
            LOG.debug("Created directory {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.checkUri(path);
        return this.rpc(client -> {
            CreateFilePOptions mergedOptions = FileSystemOptionsUtils.createFileDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            URIStatus status = client.createFile(path, mergedOptions);
            LOG.debug("Created file {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            OutStreamOptions outStreamOptions = new OutStreamOptions(mergedOptions, this.mFsContext, this.getDirectAccessConf(path));
            outStreamOptions.setUfsPath(status.getUfsPath());
            outStreamOptions.setMountId(status.getMountId());
            outStreamOptions.setAcl(status.getAcl());
            try {
                return new AlluxioFileOutStream(path, outStreamOptions, this.mFsContext);
            }
            catch (Exception e) {
                this.delete(path);
                throw e;
            }
        });
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            DeletePOptions mergedOptions = FileSystemOptionsUtils.deleteDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.delete(path, mergedOptions);
            LOG.debug("Deleted {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public boolean exists(AlluxioURI path, ExistsPOptions options) throws IOException, AlluxioException {
        this.checkUri(path);
        return this.rpc(client -> {
            ExistsPOptions mergedOptions = FileSystemOptionsUtils.existsDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            return client.exists(path, mergedOptions);
        });
    }

    @Override
    public void free(AlluxioURI path, FreePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            FreePOptions mergedOptions = FileSystemOptionsUtils.freeDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.free(path, mergedOptions);
            LOG.debug("Freed {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(URIStatus status) throws IOException, AlluxioException {
        ArrayList<BlockLocationInfo> blockLocations = new ArrayList<BlockLocationInfo>();
        List<FileBlockInfo> blocks = status.getFileBlockInfos();
        for (FileBlockInfo fileBlockInfo : blocks) {
            List<WorkerNetAddress> locations = fileBlockInfo.getBlockInfo().getLocations().stream().map(BlockLocation::getWorkerAddress).collect(Collectors.toList());
            if (locations.isEmpty()) {
                if (!fileBlockInfo.getUfsLocations().isEmpty()) {
                    Map<String, WorkerNetAddress> finalWorkerHosts = this.getHostWorkerMap();
                    locations = fileBlockInfo.getUfsLocations().stream().map(location -> (WorkerNetAddress)finalWorkerHosts.get(HostAndPort.fromString(location).getHost())).filter(Objects::nonNull).collect(Collectors.toList());
                }
                if (locations.isEmpty() && this.mFsContext.getPathConf(new AlluxioURI(status.getPath())).getBoolean(PropertyKey.USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED)) {
                    locations.addAll(this.getHostWorkerMap().values());
                    Collections.shuffle(locations);
                }
            }
            blockLocations.add(new BlockLocationInfo(fileBlockInfo, locations));
        }
        return blockLocations;
    }

    private Map<String, WorkerNetAddress> getHostWorkerMap() throws IOException {
        List<BlockWorkerInfo> workers = this.mFsContext.getCachedWorkers();
        return workers.stream().collect(Collectors.toMap(worker -> worker.getNetAddress().getHost(), BlockWorkerInfo::getNetAddress, (worker1, worker2) -> worker1));
    }

    @Override
    public AlluxioConfiguration getConf() {
        return this.mFsContext.getClusterConf();
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        URIStatus status = this.rpc(client -> {
            GetStatusPOptions mergedOptions = FileSystemOptionsUtils.getStatusDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            return client.getStatus(path, mergedOptions);
        });
        if (!status.isCompleted()) {
            LOG.debug("File {} is not yet completed. getStatus will see incomplete metadata.", (Object)path);
        }
        return status;
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        return this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptionsUtils.listStatusDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            return client.listStatus(path, mergedOptions);
        });
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptionsUtils.listStatusDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.iterateStatus(path, mergedOptions, action);
            return null;
        });
    }

    @Override
    public ListStatusPartialResult listStatusPartial(AlluxioURI path, ListStatusPartialPOptions options) throws AlluxioException, IOException {
        this.checkUri(path);
        return this.rpc(client -> {
            ListStatusPartialPOptions mergedOptions = FileSystemOptionsUtils.listStatusPartialDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            return client.listStatusPartial(path, mergedOptions);
        });
    }

    @Override
    public void loadMetadata(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ListStatusPOptions mergedOptions = FileSystemOptionsUtils.listStatusDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).setLoadMetadataType(LoadMetadataPType.ALWAYS).setLoadMetadataOnly(true).build();
            client.listStatus(path, mergedOptions);
            return null;
        });
    }

    @Override
    public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath, MountPOptions options) throws IOException, AlluxioException {
        this.checkUri(alluxioPath);
        this.rpc(client -> {
            MountPOptions mergedOptions = FileSystemOptionsUtils.mountDefaults(this.mFsContext.getPathConf(alluxioPath)).toBuilder().mergeFrom(options).build();
            client.mount(alluxioPath, ufsPath, mergedOptions);
            LOG.debug("Mount {} to {}", (Object)ufsPath, (Object)alluxioPath.getPath());
            return null;
        });
    }

    @Override
    public void updateMount(AlluxioURI alluxioPath, MountPOptions options) throws IOException, AlluxioException {
        this.checkUri(alluxioPath);
        this.rpc(client -> {
            MountPOptions mergedOptions = FileSystemOptionsUtils.mountDefaults(this.mFsContext.getPathConf(alluxioPath)).toBuilder().mergeFrom(options).build();
            client.updateMount(alluxioPath, mergedOptions);
            LOG.debug("UpdateMount on {}", (Object)alluxioPath.getPath());
            return null;
        });
    }

    @Override
    public Map<String, MountPointInfo> getMountTable(boolean checkUfs) throws IOException, AlluxioException {
        return this.rpc(client -> client.getMountTable(checkUfs));
    }

    @Override
    public List<SyncPointInfo> getSyncPathList() throws IOException, AlluxioException {
        return this.rpc(FileSystemMasterClient::getSyncPathList);
    }

    @Override
    public void persist(AlluxioURI path, ScheduleAsyncPersistencePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            ScheduleAsyncPersistencePOptions mergedOptions = FileSystemOptionsUtils.scheduleAsyncPersistDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.scheduleAsyncPersist(path, mergedOptions);
            LOG.debug("Scheduled persist for {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
        this.checkUri(path);
        AlluxioConfiguration conf = this.getDirectAccessConf(path);
        GetStatusPOptions opt = FileSystemOptionsUtils.getStatusDefaults(conf).toBuilder().setAccessMode(Bits.READ).setUpdateTimestamps(options.getUpdateLastAccessTime()).build();
        URIStatus status = this.getStatus(path, opt);
        return this.openFile(status, options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw new OpenDirectoryException(path);
        }
        if (!status.isCompleted()) {
            throw new FileIncompleteException(path);
        }
        AlluxioConfiguration conf = this.getDirectAccessConf(path);
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        InStreamOptions inStreamOptions = new InStreamOptions(status, mergedOptions, conf, this.mFsContext);
        return new AlluxioFileInStream(status, inStreamOptions, this.mFsContext);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(src);
        this.checkUri(dst);
        this.rpc(client -> {
            RenamePOptions mergedOptions = FileSystemOptionsUtils.renameDefaults(this.mFsContext.getPathConf(dst)).toBuilder().mergeFrom(options).build();
            client.rename(src, dst, mergedOptions);
            LOG.debug("Renamed {} to {}, options: {}", new Object[]{src.getPath(), dst.getPath(), mergedOptions});
            return null;
        });
    }

    @Override
    public AlluxioURI reverseResolve(AlluxioURI ufsUri) throws IOException, AlluxioException {
        return this.rpc(client -> {
            AlluxioURI path = client.reverseResolve(ufsUri);
            LOG.debug("Reverse resolved {} to {}", (Object)ufsUri, (Object)path.getPath());
            return path;
        });
    }

    @Override
    public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            SetAclPOptions mergedOptions = FileSystemOptionsUtils.setAclDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.setAcl(path, action, entries, mergedOptions);
            LOG.debug("Set ACL for {}, entries: {} options: {}", new Object[]{path.getPath(), entries, mergedOptions});
            return null;
        });
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        SetAttributePOptions mergedOptions = FileSystemOptionsUtils.setAttributeClientDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
        this.rpc(client -> {
            client.setAttribute(path, mergedOptions);
            LOG.debug("Set attributes for {}, options: {}", (Object)path.getPath(), (Object)options);
            return null;
        });
    }

    @Override
    public void startSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rpc(client -> {
            client.startSync(path);
            LOG.debug("Start syncing for {}", (Object)path.getPath());
            return null;
        });
    }

    @Override
    public void stopSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rpc(client -> {
            client.stopSync(path);
            LOG.debug("Stop syncing for {}", (Object)path.getPath());
            return null;
        });
    }

    @Override
    public void unmount(AlluxioURI path, UnmountPOptions options) throws IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            UnmountPOptions mergedOptions = FileSystemOptionsUtils.unmountDefaults(this.getDirectAccessConf(path)).toBuilder().mergeFrom(options).build();
            client.unmount(path);
            LOG.debug("Unmounted {}, options: {}", (Object)path.getPath(), (Object)mergedOptions);
            return null;
        });
    }

    @Override
    public void needsSync(AlluxioURI path) throws IOException, AlluxioException {
        this.checkUri(path);
        this.rpc(client -> {
            client.needsSync(path);
            return null;
        });
    }

    @Override
    public Optional<String> submitJob(JobRequest jobRequest) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            Optional<String> optional = client.get().submitJob(jobRequest);
            return optional;
        }
    }

    @Override
    public boolean stopJob(JobDescription jobDescription) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            boolean bl = client.get().stopJob(jobDescription);
            return bl;
        }
    }

    @Override
    public String getJobProgress(JobDescription jobDescription, JobProgressReportFormat format, boolean verbose) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            String string = client.get().getJobProgress(jobDescription, format, verbose);
            return string;
        }
    }

    @Override
    public SyncMetadataPResponse syncMetadata(AlluxioURI path, SyncMetadataPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            SyncMetadataPResponse syncMetadataPResponse = client.get().syncMetadata(path, options);
            return syncMetadataPResponse;
        }
    }

    @Override
    public SyncMetadataAsyncPResponse syncMetadataAsync(AlluxioURI path, SyncMetadataPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            SyncMetadataAsyncPResponse syncMetadataAsyncPResponse = client.get().syncMetadataAsync(path, options);
            return syncMetadataAsyncPResponse;
        }
    }

    @Override
    public GetSyncProgressPResponse getSyncProgress(long taskGroupId) throws FileDoesNotExistException, IOException, AlluxioException {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            GetSyncProgressPResponse getSyncProgressPResponse = client.get().getSyncProgress(taskGroupId);
            return getSyncProgressPResponse;
        }
    }

    @Override
    public CancelSyncMetadataPResponse cancelSyncMetadata(long taskGroupId) throws IOException, AlluxioException {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            CancelSyncMetadataPResponse cancelSyncMetadataPResponse = client.get().cancelSyncMetadata(taskGroupId);
            return cancelSyncMetadataPResponse;
        }
    }

    protected void checkUri(AlluxioURI uri) {
        Preconditions.checkNotNull(uri, "uri");
        if (!this.mFsContext.getUriValidationEnabled()) {
            return;
        }
        if (uri.hasScheme()) {
            String warnMsg = "The URI scheme \"{}\" is ignored and not required in URIs passed to the Alluxio Filesystem client.";
            switch (uri.getScheme()) {
                case "alluxio": {
                    LOG.warn(warnMsg, (Object)"alluxio");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Scheme %s:// in AlluxioURI is invalid. Schemes in filesystem operations are ignored. \"alluxio://\" or no scheme at all is valid.", uri.getScheme()));
                }
            }
        }
        if (uri.hasAuthority()) {
            Authority configured;
            boolean skipAuthorityCheck;
            LOG.warn("The URI authority (hostname and port) is ignored and not required in URIs passed to the Alluxio Filesystem client.");
            AlluxioConfiguration conf = this.mFsContext.getClusterConf();
            boolean bl = skipAuthorityCheck = conf.isSet(PropertyKey.USER_SKIP_AUTHORITY_CHECK) && conf.getBoolean(PropertyKey.USER_SKIP_AUTHORITY_CHECK);
            if (!skipAuthorityCheck && !(configured = MasterInquireClient.Factory.create(this.mFsContext.getClusterConf(), this.mFsContext.getClientContext().getUserState()).getConnectDetails().toAuthority()).equals(uri.getAuthority())) {
                throw new IllegalArgumentException(String.format("The URI authority %s does not match the configured value of %s.", uri.getAuthority(), configured));
            }
        }
    }

    /*
     * Exception decompiling
     */
    <R> R rpc(RpcCallable<FileSystemMasterClient, R> fn) throws IOException, AlluxioException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void wrapAndThrowAlluxioStatusException(AlluxioStatusException e) throws AlluxioException, IOException {
        if (e instanceof NotFoundException) {
            throw new FileDoesNotExistException(e.getMessage());
        }
        if (e instanceof AlreadyExistsException) {
            throw new FileAlreadyExistsException(e.getMessage());
        }
        if (e instanceof InvalidArgumentException) {
            throw new InvalidPathException(e.getMessage());
        }
        if (e instanceof FailedPreconditionException) {
            throw new DirectoryNotEmptyException(e.getMessage());
        }
        if (e instanceof UnavailableException || e instanceof UnauthenticatedException) {
            throw e;
        }
        throw e.toAlluxioException();
    }

    public FileSystemContext getFileSystemContext() {
        return this.mFsContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <R> R rpcKeepClientResource(RpcCallable<CloseableResource<FileSystemMasterClient>, R> fn) throws IOException, AlluxioException {
        CloseableResource<FileSystemMasterClient> client = null;
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.mFsContext.blockReinit();){
            client = this.mFsContext.acquireMasterClientResource();
            client.get().connect();
            R r2 = fn.call(client);
            return r2;
        }
        catch (NotFoundException e) {
            client.close();
            throw new FileDoesNotExistException(e.getMessage());
        }
        catch (AlreadyExistsException e) {
            client.close();
            throw new FileAlreadyExistsException(e.getMessage());
        }
        catch (InvalidArgumentException e) {
            client.close();
            throw new InvalidPathException(e.getMessage());
        }
        catch (FailedPreconditionException e) {
            client.close();
            throw new DirectoryNotEmptyException(e.getMessage());
        }
        catch (UnavailableException e) {
            client.close();
            throw e;
        }
        catch (UnauthenticatedException e) {
            client.close();
            throw e;
        }
        catch (AlluxioStatusException e) {
            client.close();
            throw e.toAlluxioException();
        }
    }

    @FunctionalInterface
    static interface RpcCallable<T, R> {
        public R call(T var1) throws IOException, AlluxioException;
    }
}

