/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.util.alluxio.shaded.client.com.ression;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.alluxio.shaded.client.io.OutputStream;
import java.nio.file.Path;

/**
 * Marshall directory following the .tar.gz specification.
 */
public class TarGzMarshaller implements DirectoryMarshaller {
  private final int mSnapshotCompressionLevel = Configuration.getInt(
      PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_LEVEL);

  @Override
  public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
    return TarUtils.writeTarGz(path, outputStream, mSnapshotCompressionLevel);
  }

  @Override
  public long read(Path path, InputStream inputStream) throws IOException {
    return TarUtils.readTarGz(path, inputStream);
  }
}
