/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.SessionInfo;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.IdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Sessions {
    private static final Logger LOG = LoggerFactory.getLogger(Sessions.class);
    public static final int MIGRATE_DATA_SESSION_ID = -3;
    public static final int MASTER_COMMAND_SESSION_ID = -4;
    public static final int CACHE_WORKER_SESSION_ID = -7;
    public static final int CACHE_UFS_SESSION_ID = -8;
    public static final int LOAD_SESSION_ID = -9;
    public static final long INTERNAL_SESSION_ID_BASE = -8L;
    private final Map<Long, SessionInfo> mSessions = new HashMap<Long, SessionInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTimedOutSessions() {
        ArrayList<Long> ret = new ArrayList<Long>();
        Map<Long, SessionInfo> map = this.mSessions;
        synchronized (map) {
            for (Map.Entry<Long, SessionInfo> entry : this.mSessions.entrySet()) {
                if (!entry.getValue().timeout()) continue;
                ret.add(entry.getKey());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(long sessionId) {
        LOG.debug("Cleaning up session {}", (Object)sessionId);
        Map<Long, SessionInfo> map = this.mSessions;
        synchronized (map) {
            this.mSessions.remove(sessionId);
        }
    }

    public static long createInternalSessionId() {
        return -8L - IdUtils.getRandomNonNegativeLong() % 0x7FFFFFFFFFFFFFF7L;
    }
}

