/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.grpc.ClientVersionClientInjector;
import alluxio.shaded.client.io.grpc.ForwardingServerCallListener;
import alluxio.shaded.client.io.grpc.Grpc;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.ServerCall;
import alluxio.shaded.client.io.grpc.ServerCallHandler;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.javax.annotation.Nullable;

public class ClientContextServerInjector
implements ServerInterceptor {
    private static final ThreadLocal<String> IP_ADDRESS_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> CLIENT_VERSION_THREAD_LOCAL = new ThreadLocal();

    @Nullable
    public static String getIpAddress() {
        return IP_ADDRESS_THREAD_LOCAL.get();
    }

    @Nullable
    public static String getClientVersion() {
        return CLIENT_VERSION_THREAD_LOCAL.get();
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.setRemoteIpAddress(call);
        this.setClientVersion(headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            @Override
            public void onHalfClose() {
                ClientContextServerInjector.this.setRemoteIpAddress(call);
                ClientContextServerInjector.this.setClientVersion(headers);
                super.onHalfClose();
            }
        };
    }

    private <ReqT, RespT> void setRemoteIpAddress(ServerCall<ReqT, RespT> call) {
        String remoteIpAddress = call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR).toString();
        IP_ADDRESS_THREAD_LOCAL.set(remoteIpAddress);
    }

    private void setClientVersion(Metadata headers) {
        String version = headers.get(ClientVersionClientInjector.S_CLIENT_VERSION_KEY);
        CLIENT_VERSION_THREAD_LOCAL.set(version);
    }
}

