/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractClient;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcServerAddress;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.master.selectionpolicy.MasterSelectionPolicy;
import alluxio.retry.RetryPolicy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Supplier;

@ThreadSafe
public abstract class AbstractMasterClient
extends AbstractClient {
    private final MasterInquireClient mMasterInquireClient;
    private final MasterSelectionPolicy mMasterSelectionPolicy;

    public AbstractMasterClient(MasterClientContext clientConf) {
        this(clientConf, MasterSelectionPolicy.Factory.primaryMaster());
    }

    public AbstractMasterClient(MasterClientContext clientConf, MasterSelectionPolicy selectionPolicy) {
        super(clientConf);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
        this.mMasterSelectionPolicy = selectionPolicy;
    }

    public AbstractMasterClient(MasterClientContext clientConf, Supplier<RetryPolicy> retryPolicySupplier) {
        super(clientConf, retryPolicySupplier);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
        this.mMasterSelectionPolicy = MasterSelectionPolicy.Factory.primaryMaster();
    }

    public AbstractMasterClient(MasterClientContext clientConf, MasterSelectionPolicy selectionPolicy, Supplier<RetryPolicy> retryPolicySupplier) {
        super(clientConf, retryPolicySupplier);
        this.mMasterInquireClient = clientConf.getMasterInquireClient();
        this.mMasterSelectionPolicy = selectionPolicy;
    }

    @Override
    public synchronized InetSocketAddress getConfAddress() throws UnavailableException {
        return this.mMasterSelectionPolicy.getPrimaryMasterAddressCached(this.mMasterInquireClient);
    }

    @Override
    protected void beforeConnect() throws IOException {
        this.mMasterSelectionPolicy.resetPrimaryMasterAddressCache();
        super.beforeConnect();
    }

    @Override
    protected void afterDisconnect() {
        super.afterDisconnect();
        this.mMasterSelectionPolicy.resetPrimaryMasterAddressCache();
    }

    @Override
    protected synchronized GrpcServerAddress queryGrpcServerAddress() throws UnavailableException {
        return GrpcServerAddress.create(this.mMasterSelectionPolicy.getGrpcMasterAddress(this.mMasterInquireClient));
    }
}

