/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import java.util.concurrent.locks.StampedLock;

public class SegmentedLock {
    private final int mNumLocks;
    private final int mBitsOfLock;
    private final int mMaskBits;
    private final StampedLock[] mLocks;
    private final int mNumBucketsPerSegment;

    public SegmentedLock(int numLocks, int numBuckets) {
        int highestBit = Integer.highestOneBit(numLocks);
        if (highestBit < numLocks) {
            numLocks = highestBit << 1;
        }
        this.mNumLocks = numLocks;
        this.mBitsOfLock = Integer.numberOfTrailingZeros(numLocks);
        this.mNumBucketsPerSegment = numBuckets / numLocks;
        int bitsOfBuckets = Integer.numberOfTrailingZeros(Integer.highestOneBit(numBuckets));
        this.mMaskBits = bitsOfBuckets - this.mBitsOfLock;
        this.mLocks = new StampedLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.mLocks[i] = new StampedLock();
        }
    }

    public void readLock(int bucket1, int bucket2) {
        int segmentIndex1 = this.getSegmentIndex(bucket1);
        int segmentIndex2 = this.getSegmentIndex(bucket2);
        this.mLocks[Math.min(segmentIndex1, segmentIndex2)].readLock();
        if (segmentIndex2 != segmentIndex1) {
            this.mLocks[Math.max(segmentIndex1, segmentIndex2)].readLock();
        }
    }

    public void unlockRead(int bucket1, int bucket2) {
        int segmentIndex1 = this.getSegmentIndex(bucket1);
        int segmentIndex2 = this.getSegmentIndex(bucket2);
        this.mLocks[Math.max(segmentIndex1, segmentIndex2)].tryUnlockRead();
        if (segmentIndex2 != segmentIndex1) {
            this.mLocks[Math.min(segmentIndex1, segmentIndex2)].tryUnlockRead();
        }
    }

    public void writeLock(int bucket) {
        this.mLocks[this.getSegmentIndex(bucket)].writeLock();
    }

    public void writeLock(int b1, int b2) {
        int segmentIndex1 = this.getSegmentIndex(b1);
        int segmentIndex2 = this.getSegmentIndex(b2);
        this.mLocks[Math.min(segmentIndex1, segmentIndex2)].writeLock();
        if (segmentIndex2 != segmentIndex1) {
            this.mLocks[Math.max(segmentIndex1, segmentIndex2)].writeLock();
        }
    }

    public void writeLock(int bucket1, int bucket2, int bucket3) {
        int segmentIndex1 = this.getSegmentIndex(bucket1);
        int segmentIndex2 = this.getSegmentIndex(bucket2);
        int segmentIndex3 = this.getSegmentIndex(bucket3);
        int maxIndex = Math.max(segmentIndex1, Math.max(segmentIndex2, segmentIndex3));
        int minIndex = Math.min(segmentIndex1, Math.min(segmentIndex2, segmentIndex3));
        int midIndex = segmentIndex1 + segmentIndex2 + segmentIndex3 - maxIndex - minIndex;
        this.mLocks[minIndex].writeLock();
        if (midIndex != minIndex) {
            this.mLocks[midIndex].writeLock();
        }
        if (maxIndex != midIndex) {
            this.mLocks[maxIndex].writeLock();
        }
    }

    public void unlockWrite(int bucket) {
        this.mLocks[this.getSegmentIndex(bucket)].tryUnlockWrite();
    }

    public void unlockWrite(int bucket1, int bucket2) {
        int segmentIndex1 = this.getSegmentIndex(bucket1);
        int segmentIndex2 = this.getSegmentIndex(bucket2);
        this.mLocks[Math.max(segmentIndex1, segmentIndex2)].tryUnlockWrite();
        if (segmentIndex2 != segmentIndex1) {
            this.mLocks[Math.min(segmentIndex1, segmentIndex2)].tryUnlockWrite();
        }
    }

    public void unlockWrite(int bucket1, int bucket2, int bucket3) {
        int segmentIndex1 = this.getSegmentIndex(bucket1);
        int segmentIndex2 = this.getSegmentIndex(bucket2);
        int segmentIndex3 = this.getSegmentIndex(bucket3);
        int maxIndex = Math.max(segmentIndex1, Math.max(segmentIndex2, segmentIndex3));
        int minIndex = Math.min(segmentIndex1, Math.min(segmentIndex2, segmentIndex3));
        int midIndex = segmentIndex1 + segmentIndex2 + segmentIndex3 - maxIndex - minIndex;
        this.mLocks[maxIndex].tryUnlockWrite();
        if (midIndex != maxIndex) {
            this.mLocks[midIndex].tryUnlockWrite();
        }
        if (minIndex != midIndex) {
            this.mLocks[minIndex].tryUnlockWrite();
        }
    }

    public void writeLockSegment(int index) {
        this.mLocks[index].writeLock();
    }

    public void unlockWriteSegment(int index) {
        this.mLocks[index].tryUnlockWrite();
    }

    public int getNumLocks() {
        return this.mNumLocks;
    }

    public int getNumBucketsPerSegment() {
        return this.mNumBucketsPerSegment;
    }

    public int getSegmentStartPos(int index) {
        return index << this.mMaskBits;
    }

    public int getSegmentIndex(int bucket) {
        return bucket >> this.mMaskBits;
    }
}

