/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.store.PageReadTargetBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ByteBufferTargetBuffer
implements PageReadTargetBuffer {
    private final ByteBuffer mTarget;

    public ByteBufferTargetBuffer(ByteBuffer target) {
        this.mTarget = target;
    }

    @Override
    public byte[] byteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.mTarget;
    }

    @Override
    public long offset() {
        return this.mTarget.position();
    }

    @Override
    public WritableByteChannel byteChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long remaining() {
        return this.mTarget.remaining();
    }

    @Override
    public void writeBytes(byte[] srcArray, int srcOffset, int length) {
        this.mTarget.put(srcArray, srcOffset, length);
    }

    @Override
    public int readFromFile(RandomAccessFile file, int length) throws IOException {
        int bytesToRead = Math.min(length, this.mTarget.remaining());
        ByteBuffer slice = this.mTarget.slice();
        slice.limit(bytesToRead);
        int bytesRead = file.getChannel().read(slice);
        this.mTarget.position(this.mTarget.position() + bytesRead);
        return bytesRead;
    }
}

