/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.client.file.ufs.UfsBaseFileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.proto.dataserver.Protocol;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoraCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DoraCacheFileSystem.class);
    public static final int DUMMY_MOUNT_ID = 0;
    private final DoraCacheClient mDoraClient;
    private final FileSystemContext mFsContext;
    private final boolean mMetadataCacheEnabled;

    public DoraCacheFileSystem(FileSystem fs, FileSystemContext context) {
        super(fs);
        this.mDoraClient = new DoraCacheClient(context, new WorkerLocationPolicy(2000));
        this.mFsContext = context;
        this.mMetadataCacheEnabled = context.getClusterConf().getBoolean(PropertyKey.DORA_CLIENT_METADATA_CACHE_ENABLED);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        if (!this.mMetadataCacheEnabled) {
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options);
        }
        try {
            return this.mDoraClient.getStatus(ufsFullPath.toString(), options);
        }
        catch (RuntimeException ex) {
            LOG.debug("Dora client get status error. Fall back to UFS.", (Throwable)ex);
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options);
        }
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        return this.openFile(this.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw new OpenDirectoryException(path);
        }
        if (!status.isCompleted()) {
            throw new FileIncompleteException(path);
        }
        AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        try {
            Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(mergedOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(mergedOptions.getReadType()).isCache()).setMountId(0L).build();
            return this.mDoraClient.getInStream(status, openUfsBlockOptions);
        }
        catch (RuntimeException ex) {
            LOG.debug("Dora client open file error. Fall back to UFS.", (Throwable)ex);
            return this.mDelegatedFileSystem.openFile(status, mergedOptions);
        }
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        ufsFullPath = new AlluxioURI(PathUtils.normalizePath(ufsFullPath.toString(), "/"));
        return this.mDelegatedFileSystem.listStatus(ufsFullPath, options);
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        return this.mDelegatedFileSystem.createFile(ufsFullPath, options);
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        this.mDelegatedFileSystem.createDirectory(ufsFullPath, options);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI srcUfsFullPath = this.convertAlluxioPathToUFSPath(src);
        AlluxioURI dstUfsFullPath = this.convertAlluxioPathToUFSPath(dst);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        this.mDelegatedFileSystem.rename(srcUfsFullPath, dstUfsFullPath, options);
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        this.mDelegatedFileSystem.iterateStatus(ufsFullPath, options, action);
    }

    private AlluxioURI convertAlluxioPathToUFSPath(AlluxioURI alluxioPath) {
        if (this.mDelegatedFileSystem instanceof UfsBaseFileSystem) {
            UfsBaseFileSystem under = (UfsBaseFileSystem)this.mDelegatedFileSystem;
            AlluxioURI rootUFS = under.getRootUFS();
            try {
                if (rootUFS.isAncestorOf(alluxioPath)) {
                    return alluxioPath;
                }
            }
            catch (InvalidPathException e) {
                LOG.error("Invalid path {}", (Object)alluxioPath);
                throw new RuntimeException(e);
            }
            String ufsFullPath = PathUtils.concatPath((Object)rootUFS, (Object)alluxioPath.toString());
            return new AlluxioURI(ufsFullPath);
        }
        return alluxioPath;
    }
}

