/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.netty;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.network.ChannelType;
import alluxio.network.netty.IdleWriteHandler;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCMessageDecoder;
import alluxio.network.protocol.RPCMessageEncoder;
import alluxio.shaded.client.io.netty.bootstrap.Bootstrap;
import alluxio.shaded.client.io.netty.buffer.PooledByteBufAllocator;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelInitializer;
import alluxio.shaded.client.io.netty.channel.ChannelOption;
import alluxio.shaded.client.io.netty.channel.ChannelPipeline;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.epoll.EpollChannelOption;
import alluxio.shaded.client.io.netty.channel.epoll.EpollMode;
import alluxio.shaded.client.io.netty.handler.timeout.IdleStateHandler;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.network.NettyUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class NettyClient {
    private static final RPCMessageEncoder ENCODER = new RPCMessageEncoder();
    private static final RPCMessageDecoder DECODER = new RPCMessageDecoder();
    private static final EventLoopGroup WORKER_GROUP = NettyUtils.createEventLoop(NettyUtils.CHANNEL_TYPE, Configuration.getInt(PropertyKey.USER_NETWORK_NETTY_WORKER_THREADS), "netty-client-worker-%d", true);

    private NettyClient() {
    }

    public static Bootstrap createClientBootstrap(SocketAddress address) {
        Bootstrap boot = new Bootstrap();
        ((Bootstrap)boot.group(WORKER_GROUP)).channel(NettyUtils.getClientChannelClass(!(address instanceof InetSocketAddress)));
        boot.option(ChannelOption.SO_KEEPALIVE, true);
        boot.option(ChannelOption.TCP_NODELAY, true);
        boot.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        if (NettyUtils.CHANNEL_TYPE == ChannelType.EPOLL) {
            boot.option(EpollChannelOption.EPOLL_MODE, EpollMode.LEVEL_TRIGGERED);
        }
        long timeoutMs = Configuration.getMs(PropertyKey.NETWORK_NETTY_HEARTBEAT_TIMEOUT_MS);
        final long heartbeatPeriodMs = Math.max(timeoutMs / 10L, 1L);
        boot.handler(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(RPCMessage.createFrameDecoder());
                pipeline.addLast(ENCODER);
                pipeline.addLast(DECODER);
                pipeline.addLast(new IdleStateHandler(0L, heartbeatPeriodMs, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast(new IdleWriteHandler());
            }
        });
        return boot;
    }
}

