package alluxio.shaded.client.org.reflections.scanners;

import alluxio.shaded.client.org.reflections.Configuration;
import alluxio.shaded.client.org.reflections.ReflectionsException;
import alluxio.shaded.client.org.reflections.Store;
import alluxio.shaded.client.org.reflections.adapters.MetadataAdapter;
import alluxio.shaded.client.org.reflections.util.Utils;
import alluxio.shaded.client.org.reflections.vfs.Vfs;

import java.util.function.Predicate;

/**
 *
 */
@SuppressWarnings({"RawUseOfParameterizedType"})
public abstract class AbstractScanner implements Scanner {

	private Configuration configuration;
	private Predicate<String> resultFilter = s -> true; //accept all by default

    public boolean acceptsInput(String file) {
        return getMetadataAdapter().acceptsInput(file);
    }

    public Object scan(Vfs.File file, Object classObject, Store store) {
        if (classObject == null) {
            try {
                classObject = configuration.getMetadataAdapter().getOrCreateClassObject(file);
            } catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        scan(classObject, store);
        return classObject;
    }

    public abstract void scan(Object cls, Store store);

    protected void put(Store store, String key, String value) {
        store.put(Utils.index(getClass()), key, value);
    }

    //
    public Configuration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(final Configuration configuration) {
        this.configuration = configuration;
    }

    public Predicate<String> getResultFilter() {
        return resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter); return this;
    }

    //
    public boolean acceptResult(final String fqn) {
		return fqn != null && resultFilter.test(fqn);
	}

	protected MetadataAdapter getMetadataAdapter() {
		return configuration.getMetadataAdapter();
	}

    //
    @Override public boolean equals(Object o) {
        return this == o || o != null && getClass() == o.getClass();
    }

    @Override public int hashCode() {
        return getClass().hashCode();
    }
}
