package alluxio.shaded.client.org.reflections.vfs;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.util.zip.ZipEntry;

/** an implementation of {@link alluxio.shaded.client.org.reflections.vfs.Vfs.File} for {@link java.util.zip.ZipEntry} */
public class ZipFile implements Vfs.File {
    private final ZipDir root;
    private final ZipEntry entry;

    public ZipFile(final ZipDir root, ZipEntry entry) {
        this.root = root;
        this.entry = entry;
    }

    public String getName() {
        String name = entry.getName();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    public String getRelativePath() {
        return entry.getName();
    }

    public InputStream openInputStream() throws IOException {
        return root.jarFile.getInputStream(entry);
    }

    @Override
    public String toString() {
        return root.getPath() + "!" + java.alluxio.shaded.client.io.File.separatorChar + entry.toString();
    }
}
