/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import java.util.List;

public class CacheManagerOptions {
    private boolean mAsyncRestoreEnabled;
    private boolean mAsyncWriteEnabled;
    private int mAsyncWriteThreads;
    private CacheEvictorOptions mCacheEvictorOptions;
    private int mMaxEvictionRetries;
    private long mPageSize;
    private List<PageStoreOptions> mPageStoreOptions;
    private boolean mQuotaEnabled;

    public static CacheManagerOptions create(AlluxioConfiguration conf) {
        CacheEvictorOptions cacheEvictorOptions = new CacheEvictorOptions().setEvictorClass(conf.getClass(PropertyKey.USER_CLIENT_CACHE_EVICTOR_CLASS)).setIsNondeterministic(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_EVICTOR_NONDETERMINISTIC_ENABLED)).setLFULogBase(conf.getDouble(PropertyKey.USER_CLIENT_CACHE_EVICTOR_LFU_LOGBASE));
        CacheManagerOptions options = new CacheManagerOptions().setAsyncRestoreEnabled(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED)).setAsyncWriteThreads(conf.getInt(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_THREADS)).setIsAsyncWriteEnabled(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED)).setMaxEvictionRetries(conf.getInt(PropertyKey.USER_CLIENT_CACHE_EVICTION_RETRIES)).setPageSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE)).setQuotaEnabled(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_QUOTA_ENABLED)).setCacheEvictorOptions(cacheEvictorOptions).setPageStoreOptions(PageStoreOptions.create(conf));
        return options;
    }

    public static CacheManagerOptions createForWorker(AlluxioConfiguration conf) {
        CacheEvictorOptions cacheEvictorOptions = new CacheEvictorOptions().setEvictorClass(conf.getClass(PropertyKey.WORKER_PAGE_STORE_EVICTOR_CLASS)).setIsNondeterministic(conf.getBoolean(PropertyKey.WORKER_PAGE_STORE_EVICTOR_NONDETERMINISTIC_ENABLED)).setLFULogBase(conf.getDouble(PropertyKey.WORKER_PAGE_STORE_EVICTOR_LFU_LOGBASE));
        CacheManagerOptions options = new CacheManagerOptions().setAsyncRestoreEnabled(conf.getBoolean(PropertyKey.WORKER_PAGE_STORE_ASYNC_RESTORE_ENABLED)).setAsyncWriteThreads(conf.getInt(PropertyKey.WORKER_PAGE_STORE_ASYNC_WRITE_THREADS)).setIsAsyncWriteEnabled(conf.getBoolean(PropertyKey.WORKER_PAGE_STORE_ASYNC_WRITE_ENABLED)).setMaxEvictionRetries(conf.getInt(PropertyKey.WORKER_PAGE_STORE_EVICTION_RETRIES)).setPageSize(conf.getBytes(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE)).setQuotaEnabled(conf.getBoolean(PropertyKey.WORKER_PAGE_STORE_QUOTA_ENABLED)).setCacheEvictorOptions(cacheEvictorOptions).setPageStoreOptions(PageStoreOptions.createForWorkerPageStore(conf));
        return options;
    }

    public boolean isAsyncRestoreEnabled() {
        return this.mAsyncRestoreEnabled;
    }

    public boolean isAsyncWriteEnabled() {
        return this.mAsyncWriteEnabled;
    }

    public int getAsyncWriteThreads() {
        return this.mAsyncWriteThreads;
    }

    public boolean isQuotaEnabled() {
        return this.mQuotaEnabled;
    }

    public int getMaxEvictionRetries() {
        return this.mMaxEvictionRetries;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public List<PageStoreOptions> getPageStoreOptions() {
        return this.mPageStoreOptions;
    }

    public CacheEvictorOptions getCacheEvictorOptions() {
        return this.mCacheEvictorOptions;
    }

    public CacheManagerOptions setAsyncRestoreEnabled(boolean isAsyncRestoreEnabled) {
        this.mAsyncRestoreEnabled = isAsyncRestoreEnabled;
        return this;
    }

    public CacheManagerOptions setIsAsyncWriteEnabled(boolean isAsyncWriteEnabled) {
        this.mAsyncWriteEnabled = isAsyncWriteEnabled;
        return this;
    }

    public CacheManagerOptions setAsyncWriteThreads(int asyncWriteThreads) {
        this.mAsyncWriteThreads = asyncWriteThreads;
        return this;
    }

    public CacheManagerOptions setCacheEvictorOptions(CacheEvictorOptions cacheEvictorOptions) {
        this.mCacheEvictorOptions = cacheEvictorOptions;
        return this;
    }

    public CacheManagerOptions setMaxEvictionRetries(int maxEvictionRetries) {
        this.mMaxEvictionRetries = maxEvictionRetries;
        return this;
    }

    public CacheManagerOptions setPageSize(long pageSize) {
        this.mPageSize = pageSize;
        return this;
    }

    public CacheManagerOptions setQuotaEnabled(boolean isQuotaEnabled) {
        this.mQuotaEnabled = isQuotaEnabled;
        return this;
    }

    public CacheManagerOptions setPageStoreOptions(List<PageStoreOptions> pageStoreOptions) {
        this.mPageStoreOptions = pageStoreOptions;
        return this;
    }
}

