/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Pair<T1, T2> {
    private T1 mFirst;
    private T2 mSecond;

    public Pair(T1 first, T2 second) {
        this.mFirst = first;
        this.mSecond = second;
    }

    public Pair() {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equal(this.mFirst, that.mFirst) && Objects.equal(this.mSecond, that.mSecond);
    }

    public T1 getFirst() {
        return this.mFirst;
    }

    public T2 getSecond() {
        return this.mSecond;
    }

    public int hashCode() {
        return Objects.hashCode(this.mFirst, this.mSecond);
    }

    public void setFirst(T1 first) {
        this.mFirst = first;
    }

    public void setSecond(T2 second) {
        this.mSecond = second;
    }

    public String toString() {
        return "Pair(" + this.mFirst + "," + this.mSecond + ")";
    }
}

