/*
 * Decompiled with CFR 0.152.
 */
package alluxio.file;

import alluxio.file.ReadTargetBuffer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class NettyBufTargetBuffer
implements ReadTargetBuffer {
    private final ByteBuf mTarget;

    public NettyBufTargetBuffer(ByteBuf target) {
        this.mTarget = target;
    }

    @Override
    public byte[] byteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer byteBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int offset() {
        return this.mTarget.writerIndex();
    }

    @Override
    public void offset(int newOffset) {
        this.mTarget.writerIndex(newOffset);
    }

    @Override
    public WritableByteChannel byteChannel() {
        return new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                int readableBytes = src.remaining();
                NettyBufTargetBuffer.this.mTarget.writeBytes(src);
                return readableBytes - src.remaining();
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public long remaining() {
        return this.mTarget.writableBytes();
    }

    @Override
    public void writeBytes(byte[] srcArray, int srcOffset, int length) {
        this.mTarget.writeBytes(srcArray, srcOffset, length);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        this.mTarget.writeBytes(buf);
    }

    @Override
    public int readFromFile(RandomAccessFile file, int length) throws IOException {
        try (FileChannel channel = file.getChannel();){
            int n = this.mTarget.writeBytes(channel, length);
            return n;
        }
    }

    @Override
    public int readFromInputStream(InputStream is, int length) throws IOException {
        ByteBuffer slice;
        int bytesToRead = Math.min(length, this.mTarget.writableBytes());
        ReadableByteChannel source = Channels.newChannel(is);
        int bytesRead = source.read(slice = this.mTarget.nioBuffer(this.mTarget.writerIndex(), bytesToRead));
        if (bytesRead > 0) {
            this.mTarget.writerIndex(this.mTarget.writerIndex() + bytesRead);
        }
        return bytesRead;
    }
}

