/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.bin;

import alluxio.shaded.client.software.amazon.ionIonException;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionimpl.bin.AbstractSymbolTable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Symbols {
    private static final List<ionSymbolToken> SYSTEM_TOKENS = Collections.unmodifiableList(Arrays.asList(Symbols.symbol("$ion", 1), Symbols.symbol("$ion_1_0", 2), Symbols.symbol("$ion_symbol_table", 3), Symbols.symbol("name", 4), Symbols.symbol("version", 5), Symbols.symbol("imports", 6), Symbols.symbol("symbols", 7), Symbols.symbol("max_id", 8), Symbols.symbol("$ion_shared_symbol_table", 9)));
    private static final Map<String, ionSymbolToken> SYSTEM_TOKEN_MAP;
    private static ionSymbolTable SYSTEM_SYMBOL_TABLE;

    private Symbols() {
    }

    public static ionSymbolToken symbol(final String name, final int val) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (val <= 0) {
            throw new IllegalArgumentException("Symbol value must be positive: " + val);
        }
        return new ionSymbolToken(){

            public String getText() {
                return name;
            }

            public String assumeText() {
                return name;
            }

            public int getSid() {
                return val;
            }

            public String toString() {
                return "(symbol '" + this.getText() + "' " + this.getSid() + ")";
            }
        };
    }

    public static Iterator<String> symbolNameIterator(final Iterator<ionSymbolToken> tokenIter) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenIter.hasNext();
            }

            @Override
            public String next() {
                return ((ionSymbolToken)tokenIter.next()).getText();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ionSymbolToken systemSymbol(int sid) {
        if (sid < 1 || sid > 9) {
            throw new IllegalArgumentException("No such system SID: " + sid);
        }
        return SYSTEM_TOKENS.get(sid - 1);
    }

    public static ionSymbolTable systemSymbolTable() {
        return SYSTEM_SYMBOL_TABLE;
    }

    public static Collection<ionSymbolToken> systemSymbols() {
        return SYSTEM_TOKENS;
    }

    public static ionSymbolTable unknownSharedSymbolTable(final String name, final int version, final int maxId) {
        return new AbstractSymbolTable(name, version){

            @Override
            public Iterator<String> iterateDeclaredSymbolNames() {
                return new Iterator<String>(){
                    int id = 1;

                    @Override
                    public boolean hasNext() {
                        return this.id <= maxId;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.id;
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean isSystemTable() {
                return false;
            }

            @Override
            public boolean isSubstitute() {
                return true;
            }

            @Override
            public boolean isSharedTable() {
                return true;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public boolean isLocalTable() {
                return false;
            }

            @Override
            public ionSymbolToken intern(String text) {
                throw new UnsupportedOperationException("Cannot intern into substitute unknown shared symbol table: " + name + " version " + version);
            }

            @Override
            public ionSymbolTable getSystemSymbolTable() {
                return Symbols.systemSymbolTable();
            }

            @Override
            public int getMaxId() {
                return maxId;
            }

            @Override
            public ionSymbolTable[] getImportedTables() {
                return null;
            }

            @Override
            public int getImportedMaxId() {
                return 0;
            }

            @Override
            public String findKnownSymbol(int id) {
                return null;
            }

            @Override
            public ionSymbolToken find(String text) {
                return null;
            }
        };
    }

    static {
        HashMap<String, ionSymbolToken> symbols = new HashMap<String, ionSymbolToken>();
        for (ionSymbolToken token : SYSTEM_TOKENS) {
            symbols.put(token.getText(), token);
        }
        SYSTEM_TOKEN_MAP = Collections.unmodifiableMap(symbols);
        SYSTEM_SYMBOL_TABLE = new AbstractSymbolTable("$ion", 1){

            @Override
            public ionSymbolTable[] getImportedTables() {
                return null;
            }

            @Override
            public int getImportedMaxId() {
                return 0;
            }

            @Override
            public boolean isSystemTable() {
                return true;
            }

            @Override
            public boolean isSubstitute() {
                return false;
            }

            @Override
            public boolean isSharedTable() {
                return true;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public boolean isLocalTable() {
                return false;
            }

            @Override
            public ionSymbolToken intern(String text) {
                ionSymbolToken token = (ionSymbolToken)SYSTEM_TOKEN_MAP.get(text);
                if (token == null) {
                    throw new ionIonException("Cannot intern new symbol into system symbol table");
                }
                return token;
            }

            @Override
            public String findKnownSymbol(int id) {
                if (id < 1) {
                    throw new IllegalArgumentException("SID cannot be less than 1: " + id);
                }
                if (id > 9) {
                    return null;
                }
                return ((ionSymbolToken)SYSTEM_TOKENS.get(id - 1)).getText();
            }

            @Override
            public ionSymbolToken find(String text) {
                return (ionSymbolToken)SYSTEM_TOKEN_MAP.get(text);
            }

            @Override
            public ionSymbolTable getSystemSymbolTable() {
                return this;
            }

            @Override
            public int getMaxId() {
                return 9;
            }

            @Override
            public Iterator<String> iterateDeclaredSymbolNames() {
                return Symbols.symbolNameIterator(SYSTEM_TOKENS.iterator());
            }
        };
    }
}

