/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.shaded.client.com.amazonaws.util.EC2MetadataUtils;
import alluxio.shaded.client.com.google.common.io.CharStreams;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.http.HttpResponse;
import alluxio.shaded.client.org.apache.http.client.config.RequestConfig;
import alluxio.shaded.client.org.apache.http.client.methods.HttpGet;
import alluxio.shaded.client.org.apache.http.impl.client.CloseableHttpClient;
import alluxio.shaded.client.org.apache.http.impl.client.HttpClientBuilder;
import alluxio.shaded.client.org.apache.http.util.EntityUtils;
import alluxio.util.io.FileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EnvironmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentUtils.class);

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static boolean isDocker() {
        return FileUtils.exists("/.dockerenv");
    }

    public static boolean isKubernetes() {
        return System.getenv("KUBERNETES_SERVICE_HOST") != null;
    }

    public static boolean isEC2() {
        return EnvironmentUtils.isEC2WithUUID() || EnvironmentUtils.isEC2WithProductUUID() || EnvironmentUtils.isEC2WithInstanceIdentity();
    }

    public static boolean isGoogleComputeEngine() {
        return EnvironmentUtils.isGCEWithMetadata() || EnvironmentUtils.isGCEWithBiosVendor();
    }

    public static String getEC2ProductCode() {
        try {
            List<String> productCodes = EC2MetadataUtils.getProductCodes();
            if (productCodes == null || productCodes.size() < 1) {
                return "";
            }
            return productCodes.get(0);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static boolean isCFT(String userData) {
        return !userData.isEmpty() && userData.contains("cft_configure");
    }

    public static boolean isEMR(String userData) {
        return !userData.isEmpty() && userData.contains("emr-apps") && userData.contains("emr-platform");
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static boolean isEC2WithUUID() {
        try {
            return EnvironmentUtils.ec2UUIDFileExistsWithID("/sys/hypervisor/uuid", "ec2");
        }
        catch (Throwable t) {
            return false;
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static boolean isEC2WithProductUUID() {
        try {
            return EnvironmentUtils.ec2UUIDFileExistsWithID("/sys/devices/virtual/dmi/id/product_uuid", "EC2");
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isEC2WithInstanceIdentity() {
        try {
            EC2MetadataUtils.getInstanceInfo();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isGCEWithMetadata() {
        try {
            String url = "http://metadata.google.internal/computeMetadata/v1/instance/zone";
            HttpGet post = new HttpGet(url);
            post.setHeader("Metadata-Flavor", "Google");
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build()).build();
            HttpResponse response = client.execute(post);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                return false;
            }
            String zone = EntityUtils.toString(response.getEntity(), "UTF-8");
            return !zone.isEmpty();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isGCEWithBiosVendor() {
        boolean bl;
        Process process = Runtime.getRuntime().exec("sudo dmidecode -s bios-vendor");
        InputStreamReader reader = new InputStreamReader(process.getInputStream());
        try {
            String output = CharStreams.toString(reader);
            bl = output.contains("Google");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                return false;
            }
        }
        ((Reader)reader).close();
        return bl;
    }

    private static boolean ec2UUIDFileExistsWithID(String filePath, String identifier) throws IOException {
        if (FileUtils.exists(filePath)) {
            int length = identifier.length();
            byte[] array = new byte[length];
            try (FileInputStream in = new FileInputStream(filePath);){
                int offset;
                int read;
                for (offset = 0; offset < length && (read = ((InputStream)in).read(array, offset, length - offset)) != -1; offset += read) {
                }
                if (offset != length) {
                    read = 0;
                    return read != 0;
                }
                String content = new String(array);
                if (content.equals(identifier)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private EnvironmentUtils() {
    }
}

