/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.client.file.dora.netty.NettyDataReader;
import alluxio.client.file.dora.netty.PartialReadException;
import alluxio.file.ReadTargetBuffer;
import alluxio.shaded.client.com.google.common.base.Throwables;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;

@ThreadSafe
public class DoraCachePositionReader
implements PositionReader {
    private final NettyDataReader mNettyReader;
    private final long mFileLength;
    private final CloseableSupplier<PositionReader> mFallbackReader;
    private volatile boolean mClosed;

    public DoraCachePositionReader(NettyDataReader dataReader, long length, CloseableSupplier<PositionReader> fallbackReader) {
        this.mNettyReader = dataReader;
        this.mFileLength = length;
        this.mFallbackReader = fallbackReader;
    }

    @Override
    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        if (position >= this.mFileLength) {
            return -1;
        }
        try {
            return this.mNettyReader.read(position, buffer, length);
        }
        catch (PartialReadException e) {
            int bytesRead = e.getBytesRead();
            if (bytesRead == 0) {
                Throwables.propagateIfPossible(e.getCause(), IOException.class);
                throw new IOException(e.getCause());
            }
            return bytesRead;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mNettyReader.close();
        this.mFallbackReader.close();
    }
}

