/*
 * Decompiled with CFR 0.152.
 */
package alluxio.exception.status;

import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.BackupAbortedException;
import alluxio.exception.BackupDelegationException;
import alluxio.exception.BackupException;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockInfoException;
import alluxio.exception.BusyException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidFileSizeException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.JobDoesNotExistException;
import alluxio.exception.RegisterLeaseNotFoundException;
import alluxio.exception.UfsBlockAccessTokenUnavailableException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.status.AbortedException;
import alluxio.exception.status.AlreadyExistsException;
import alluxio.exception.status.CancelledException;
import alluxio.exception.status.DataLossException;
import alluxio.exception.status.DeadlineExceededException;
import alluxio.exception.status.FailedPreconditionException;
import alluxio.exception.status.InternalException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.OutOfRangeException;
import alluxio.exception.status.PermissionDeniedException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.exception.status.UnimplementedException;
import alluxio.exception.status.UnknownException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusException;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import javax.security.sasl.SaslException;

public class AlluxioStatusException
extends IOException {
    private static final long serialVersionUID = -7422144873058169662L;
    private final Status mStatus;

    public AlluxioStatusException(Status status) {
        super(status.getDescription(), status.getCause());
        this.mStatus = status;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public Status.Code getStatusCode() {
        return this.mStatus.getCode();
    }

    public AlluxioException toAlluxioException() {
        switch (this.mStatus.getCode()) {
            case PERMISSION_DENIED: 
            case UNAUTHENTICATED: {
                return new AccessControlException(this.getMessage(), this);
            }
            case ABORTED: 
            case ALREADY_EXISTS: 
            case CANCELLED: 
            case DATA_LOSS: 
            case DEADLINE_EXCEEDED: 
            case FAILED_PRECONDITION: 
            case INTERNAL: 
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case OUT_OF_RANGE: 
            case RESOURCE_EXHAUSTED: {
                if ("BusyException".equals(this.getMessage())) {
                    MetricsSystem.counter(MetricKey.CLIENT_BUSY_EXCEPTION_COUNT.getName()).inc(1L);
                    return new BusyException();
                }
                return new AlluxioException(this.getMessage(), this);
            }
        }
        return new AlluxioException(this.getMessage(), this);
    }

    public StatusException toGrpcStatusException() {
        return this.mStatus.asException();
    }

    public static AlluxioStatusException from(Status status) {
        Preconditions.checkNotNull(status, "status");
        Preconditions.checkArgument(status != Status.OK, "OK is not an error status");
        String message = status.getDescription();
        Throwable cause = status.getCause();
        switch (status.getCode()) {
            case CANCELLED: {
                return new CancelledException(message, cause);
            }
            case INVALID_ARGUMENT: {
                return new InvalidArgumentException(message, cause);
            }
            case DEADLINE_EXCEEDED: {
                return new DeadlineExceededException(message, cause);
            }
            case NOT_FOUND: {
                return new NotFoundException(message, cause);
            }
            case ALREADY_EXISTS: {
                return new AlreadyExistsException(message, cause);
            }
            case PERMISSION_DENIED: {
                return new PermissionDeniedException(message, cause);
            }
            case UNAUTHENTICATED: {
                return new UnauthenticatedException(message, cause);
            }
            case RESOURCE_EXHAUSTED: {
                return new ResourceExhaustedException(message, cause);
            }
            case FAILED_PRECONDITION: {
                return new FailedPreconditionException(message, cause);
            }
            case ABORTED: {
                return new AbortedException(message, cause);
            }
            case OUT_OF_RANGE: {
                return new OutOfRangeException(message, cause);
            }
            case UNIMPLEMENTED: {
                return new UnimplementedException(message, cause);
            }
            case INTERNAL: {
                return new InternalException(message, cause);
            }
            case UNAVAILABLE: {
                return new UnavailableException(message, cause);
            }
            case DATA_LOSS: {
                return new DataLossException(message, cause);
            }
        }
        for (Throwable nestedCause = cause; nestedCause != null; nestedCause = nestedCause.getCause()) {
            if (!(nestedCause instanceof ClosedChannelException)) continue;
            return new UnavailableException(message, cause);
        }
        return new UnknownException(message, cause);
    }

    public static AlluxioStatusException fromCheckedException(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (IOException e) {
            return AlluxioStatusException.fromIOException(e);
        }
        catch (AlluxioException e) {
            return AlluxioStatusException.fromAlluxioException(e);
        }
        catch (InterruptedException e) {
            return new CancelledException(e);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Expected a checked exception but got " + e);
        }
        catch (Exception e) {
            return new UnknownException(e);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Expected a checked exception but got " + t);
        }
    }

    public static AlluxioStatusException fromThrowable(Throwable t) {
        if (t instanceof IOException) {
            return AlluxioStatusException.fromIOException((IOException)t);
        }
        if (t instanceof AlluxioException) {
            return AlluxioStatusException.fromAlluxioException((AlluxioException)t);
        }
        if (t instanceof AlluxioRuntimeException) {
            return AlluxioStatusException.from(((AlluxioRuntimeException)t).getStatus());
        }
        if (t instanceof StatusRuntimeException) {
            return AlluxioStatusException.fromStatusRuntimeException((StatusRuntimeException)t);
        }
        if (t instanceof InterruptedException) {
            return new CancelledException(t);
        }
        if (t instanceof Error || t instanceof RuntimeException) {
            return new InternalException(t);
        }
        return new UnknownException(t);
    }

    public static AlluxioStatusException fromStatusRuntimeException(StatusRuntimeException e) {
        return AlluxioStatusException.from(e.getStatus().withCause(e));
    }

    public static AlluxioStatusException fromAlluxioException(AlluxioException ae) {
        try {
            throw ae;
        }
        catch (AccessControlException e) {
            return new PermissionDeniedException(e);
        }
        catch (BusyException e) {
            return new ResourceExhaustedException(e);
        }
        catch (BlockAlreadyExistsException | FileAlreadyCompletedException | FileAlreadyExistsException e) {
            return new AlreadyExistsException(e);
        }
        catch (FileDoesNotExistException | JobDoesNotExistException e) {
            return new NotFoundException(e);
        }
        catch (BlockInfoException | InvalidFileSizeException | InvalidPathException e) {
            return new InvalidArgumentException(e);
        }
        catch (ConnectionFailedException | RegisterLeaseNotFoundException | UfsBlockAccessTokenUnavailableException e) {
            return new UnavailableException(e);
        }
        catch (BackupDelegationException | DirectoryNotEmptyException | InvalidWorkerStateException e) {
            return new FailedPreconditionException(e);
        }
        catch (BackupAbortedException e) {
            return new AbortedException(e);
        }
        catch (BackupException e) {
            return new InternalException(e);
        }
        catch (AlluxioException e) {
            return new UnknownException(e);
        }
    }

    public static AlluxioStatusException fromIOException(IOException ioe) {
        try {
            throw ioe;
        }
        catch (FileNotFoundException e) {
            return new NotFoundException(e);
        }
        catch (MalformedURLException e) {
            return new InvalidArgumentException(e);
        }
        catch (UserPrincipalNotFoundException e) {
            return new UnauthenticatedException(e);
        }
        catch (ClosedChannelException e) {
            return new FailedPreconditionException(e);
        }
        catch (AlluxioStatusException e) {
            return e;
        }
        catch (SaslException e) {
            return new UnauthenticatedException(e);
        }
        catch (IOException e) {
            return new UnknownException(e);
        }
    }
}

