/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.buffer.AbstractReferenceCountedByteBuf;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.ByteBufAllocator;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

abstract class RefCountedNioByteBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer mDelegate;
    protected int mCapacity;

    protected RefCountedNioByteBuf(ByteBuffer buffer, int capacity, int maxCapacity) {
        super(maxCapacity);
        Preconditions.checkArgument(capacity <= maxCapacity);
        Preconditions.checkArgument(maxCapacity <= buffer.capacity());
        buffer.clear();
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.mDelegate = buffer;
        this.mCapacity = capacity;
        this.clear();
    }

    @Override
    protected byte _getByte(int index) {
        return this.mDelegate.get(index);
    }

    @Override
    protected short _getShort(int index) {
        return this.mDelegate.getShort(index);
    }

    @Override
    protected short _getShortLE(int index) {
        return Short.reverseBytes(this._getShort(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        byte first = this._getByte(index);
        byte second = this._getByte(index + 1);
        byte third = this._getByte(index + 2);
        return Byte.toUnsignedInt(first) << 16 | Byte.toUnsignedInt(second) << 8 | Byte.toUnsignedInt(third);
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        byte first = this._getByte(index);
        byte second = this._getByte(index + 1);
        byte third = this._getByte(index + 2);
        return Byte.toUnsignedInt(third) << 16 | Byte.toUnsignedInt(second) << 8 | Byte.toUnsignedInt(first);
    }

    @Override
    protected int _getInt(int index) {
        return this.mDelegate.getInt(index);
    }

    @Override
    protected int _getIntLE(int index) {
        return Integer.reverseBytes(this._getInt(index));
    }

    @Override
    protected long _getLong(int index) {
        return this.mDelegate.getLong(index);
    }

    @Override
    protected long _getLongLE(int index) {
        return Long.reverseBytes(this._getLong(index));
    }

    @Override
    protected void _setByte(int index, int value) {
        this.mDelegate.put(index, (byte)value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.mDelegate.putShort(index, (short)value);
    }

    @Override
    protected void _setShortLE(int index, int value) {
        this.mDelegate.putShort(index, Short.reverseBytes((short)value));
    }

    @Override
    protected void _setMedium(int index, int value) {
        byte first = (byte)((value & 0xFF0000) >> 16);
        byte second = (byte)((value & 0xFF00) >> 8);
        byte third = (byte)(value & 0xFF);
        this._setByte(index, first);
        this._setByte(index + 1, second);
        this._setByte(index + 2, third);
    }

    @Override
    protected void _setMediumLE(int index, int value) {
        byte first = (byte)((value & 0xFF0000) >> 16);
        byte second = (byte)((value & 0xFF00) >> 8);
        byte third = (byte)(value & 0xFF);
        this._setByte(index, third);
        this._setByte(index + 1, second);
        this._setByte(index + 2, first);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.mDelegate.putInt(index, value);
    }

    @Override
    protected void _setIntLE(int index, int value) {
        this.mDelegate.putInt(index, Integer.reverseBytes(value));
    }

    @Override
    protected void _setLong(int index, long value) {
        this.mDelegate.putLong(index, value);
    }

    @Override
    protected void _setLongLE(int index, long value) {
        this.mDelegate.putLong(index, Long.reverseBytes(value));
    }

    @Override
    public int capacity() {
        return this.mCapacity;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        Preconditions.checkArgument(newCapacity >= 0 && newCapacity <= this.maxCapacity(), "invalid new capacity %s, max capacity is %s", newCapacity, this.maxCapacity());
        this.ensureAccessible();
        this.mCapacity = newCapacity;
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return ByteBufAllocator.DEFAULT;
    }

    @Override
    public ByteOrder order() {
        assert (this.mDelegate.order() == ByteOrder.BIG_ENDIAN);
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.mDelegate.isDirect();
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.ensureIndexInBounds(index, this.capacity(), dstIndex, dst.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        dst.setBytes(dstIndex, dup);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.ensureIndexInBounds(index, this.capacity(), dstIndex, dst.length, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        dup.get(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.ensureIndexInBounds(index, this.capacity(), dst.position(), dst.capacity(), dst.remaining());
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + dst.remaining());
        dst.put(dup);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.ensureIndexInBounds(index, this.capacity(), 0L, Integer.MAX_VALUE, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        if (dup.hasArray()) {
            byte[] byteArray = dup.array();
            int arrayOffset = dup.arrayOffset();
            out.write(byteArray, arrayOffset + index, length);
        } else {
            byte[] chunk = new byte[Math.min(length, 4096)];
            while (dup.remaining() > 0) {
                int transferLength = Math.min(chunk.length, dup.remaining());
                dup.get(chunk, 0, transferLength);
                out.write(chunk, 0, transferLength);
            }
        }
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.ensureIndexInBounds(index, this.capacity(), 0L, Integer.MAX_VALUE, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return out.write(dup);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.ensureIndexInBounds(index, this.capacity(), position, Long.MAX_VALUE, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return out.write(dup, position);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.ensureIndexInBounds(srcIndex, src.capacity(), index, this.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index).limit(index + length);
        src.getBytes(srcIndex, dup);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.ensureIndexInBounds(srcIndex, src.length, index, this.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        dup.put(src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.ensureIndexInBounds(src.position(), src.limit(), index, this.capacity(), src.remaining());
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + src.remaining());
        dup.put(src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.ensureIndexInBounds(0L, Integer.MAX_VALUE, index, this.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        if (dup.hasArray()) {
            byte[] bufferArray = dup.array();
            int arrayOffset = dup.arrayOffset();
            return in.read(bufferArray, arrayOffset + index, length);
        }
        byte[] chunk = new byte[Math.min(length, 4096)];
        while (dup.remaining() > 0) {
            int transferLength = Math.min(chunk.length, dup.remaining());
            int read = in.read(chunk, 0, transferLength);
            if (read < 0) {
                if (dup.position() != index) break;
                return -1;
            }
            dup.put(chunk, 0, read);
        }
        return dup.position() - index;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.ensureIndexInBounds(0L, Integer.MAX_VALUE, index, this.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return in.read(dup);
    }

    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        this.ensureIndexInBounds(position, in.size(), index, this.capacity(), length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return in.read(dup, position);
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.ensureIndexInBounds(index, this.capacity(), 0L, Long.MAX_VALUE, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return Unpooled.copiedBuffer(dup);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.ensureIndexInBounds(index, this.capacity(), 0L, Integer.MAX_VALUE, length);
        ByteBuffer dup = this.mDelegate.duplicate();
        dup.position(index);
        dup.limit(index + length);
        return dup.slice();
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        this.ensureIndexInBounds(index, this.capacity(), 0L, Integer.MAX_VALUE, length);
        return (ByteBuffer)this.mDelegate.duplicate().clear().position(index).limit(index + length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        ByteBuffer[] buffers = new ByteBuffer[]{this.nioBuffer(index, length)};
        return buffers;
    }

    @Override
    public boolean hasArray() {
        return this.mDelegate.hasArray();
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.mDelegate.array();
    }

    @Override
    public int arrayOffset() {
        return this.mDelegate.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException("memoryAddress()");
    }

    private void ensureIndexInBounds(long index, long srcCapacity, long dstIndex, long dstCapacity, int length) {
        this.ensureAccessible();
        if (srcCapacity < 0L || dstCapacity < 0L || length < 0) {
            throw new IndexOutOfBoundsException(String.format("negative capacity or length: srcCapacity %d, dstCapacity %d, length %d", srcCapacity, dstCapacity, length));
        }
        if (index < 0L || index > srcCapacity) {
            throw new IndexOutOfBoundsException(String.format("invalid index %d, srcCapacity %d", index, srcCapacity));
        }
        if (index + (long)length < 0L || index + (long)length > srcCapacity) {
            throw new IndexOutOfBoundsException(String.format("index %d + length %d exceeds srcCapacity %d", index, length, srcCapacity));
        }
        if (dstIndex < 0L || dstIndex > dstCapacity) {
            throw new IndexOutOfBoundsException(String.format("invalid dstIndex %d, dstCapacity %d", dstIndex, dstCapacity));
        }
        if (dstIndex + (long)length < 0L || dstIndex + (long)length > dstCapacity) {
            throw new IndexOutOfBoundsException(String.format("dstIndex %d + length %d exceeds dstCapacity %d", dstIndex, length, srcCapacity));
        }
    }
}

