/*
 * Decompiled with CFR 0.152.
 */
package alluxio.recorder;

import alluxio.recorder.NoopRecorder;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.helpers.MessageFormatter;

@NotThreadSafe
public class Recorder {
    private static final int MAX_RECORDS_COUNT = 10000;
    private final LinkedList<String> mRecords = new LinkedList();

    public void record(String message) {
        this.mRecords.add(message);
        if (this.mRecords.size() > 10000) {
            this.mRecords.removeFirst();
        }
    }

    public void record(String format, Object ... arguments) {
        this.record(MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public List<String> takeRecords() {
        ImmutableList<String> records = ImmutableList.copyOf(this.mRecords);
        this.mRecords.clear();
        return records;
    }

    public static Recorder noopRecorder() {
        return NoopRecorder.INSTANCE;
    }
}

