/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.bin;

import alluxio.shaded.client.software.amazon.ionimpl.bin.Block;
import alluxio.shaded.client.software.amazon.ionimpl.bin.BlockAllocator;
import alluxio.shaded.client.software.amazon.ionimpl.bin.BlockAllocatorProvider;

final class BlockAllocatorProviders {
    private static final BlockAllocatorProvider BASIC_PROVIDER = new BasicBlockAllocatorProvider();

    private BlockAllocatorProviders() {
    }

    public static BlockAllocatorProvider basicProvider() {
        return BASIC_PROVIDER;
    }

    private static final class BasicBlockAllocatorProvider
    extends BlockAllocatorProvider {
        private BasicBlockAllocatorProvider() {
        }

        public BlockAllocator vendAllocator(final int blockSize) {
            return new BlockAllocator(){

                public Block allocateBlock() {
                    return new Block(new byte[blockSize]){

                        public void close() {
                        }
                    };
                }

                public int getBlockSize() {
                    return blockSize;
                }

                public void close() {
                }
            };
        }
    }
}

