/*
 * Copyright (C) 2010 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in alluxio.shaded.client.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Static utilities for working with the eight primitive types and {@code void}, and value types for
 * treating them as unsigned.
 *
 * <p>This package is a part of the open-source <a href="http://github.alluxio.shaded.client.com.google/guava">Guava</a>
 * library.
 *
 * <p>See the Guava User Guide article on <a
 * href="https://github.alluxio.shaded.client.com.google/guava/wiki/PrimitivesExplained">primitive utilities</a>.
 *
 * <h2>Contents</h2>
 *
 * <h3>General static utilities</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Primitives}
 * </ul>
 *
 * <h3>Per-type static utilities</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Booleans}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Bytes}
 *       <ul>
 *         <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.SignedBytes}
 *         <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.UnsignedBytes}
 *       </ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Chars}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Doubles}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Floats}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Ints}
 *       <ul>
 *         <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.UnsignedInts}
 *       </ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Longs}
 *       <ul>
 *         <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.UnsignedLongs}
 *       </ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.Shorts}
 * </ul>
 *
 * <h3>Value types</h3>
 *
 * <ul>
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.UnsignedInteger}
 *   <li>{@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives.UnsignedLong}
 * </ul>
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.primitives;

import alluxio.shaded.client.com.google.errorprone.annotations.CheckReturnValue;
import alluxio.shaded.client.javax.annotation.ParametersAreNonnullByDefault;
