/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.file.ByteArrayTargetBuffer;
import alluxio.file.ByteBufferTargetBuffer;
import alluxio.file.NettyBufTargetBuffer;
import alluxio.file.ReadTargetBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

@ThreadSafe
public interface PositionReader
extends Closeable {
    default public int read(long position, byte[] buffer, int length) throws IOException {
        return this.read(position, new ByteArrayTargetBuffer(buffer, 0), length);
    }

    default public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.read(position, new ByteArrayTargetBuffer(buffer, offset), length);
    }

    default public int read(long position, ByteBuffer buffer, int length) throws IOException {
        return this.read(position, new ByteBufferTargetBuffer(buffer), length);
    }

    default public int read(long position, ByteBuf buffer, int length) throws IOException {
        return this.read(position, new NettyBufTargetBuffer(buffer), length);
    }

    default public int read(long position, ReadTargetBuffer buffer, int length) throws IOException {
        Preconditions.checkArgument(length >= 0, "length should be non-negative");
        Preconditions.checkArgument(position >= 0L, "position should be non-negative");
        Preconditions.checkArgument(buffer.remaining() >= (long)length, "given buffer should have enough space to write given length");
        if (length == 0) {
            return 0;
        }
        return this.readInternal(position, buffer, length);
    }

    public int readInternal(long var1, ReadTargetBuffer var3, int var4) throws IOException;

    @Override
    default public void close() throws IOException {
    }
}

