/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.TimeBoundPageStore;
import alluxio.client.file.cache.store.LocalPageStore;
import alluxio.client.file.cache.store.MemoryPageStore;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.RocksPageStore;
import alluxio.exception.PageNotFoundException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PageStore
extends AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(PageStore.class);

    public static PageStore create(PageStoreOptions options) {
        PageStore pageStore;
        LOG.info("Opening PageStore with option={}", (Object)options.toString());
        switch (options.getType()) {
            case LOCAL: {
                pageStore = new LocalPageStore(options);
                break;
            }
            case ROCKS: {
                pageStore = RocksPageStore.open(options);
                break;
            }
            case MEM: {
                pageStore = new MemoryPageStore((int)options.getPageSize());
                break;
            }
            default: {
                throw new IllegalArgumentException("Incompatible PageStore " + (Object)((Object)options.getType()) + " specified");
            }
        }
        if (options.getTimeoutDuration() > 0L) {
            return new TimeBoundPageStore(pageStore, options);
        }
        return pageStore;
    }

    default public void putTemporary(PageId pageId, byte[] page) throws ResourceExhaustedException, IOException {
        this.put(pageId, page, true);
    }

    default public void put(PageId pageId, byte[] page) throws ResourceExhaustedException, IOException {
        this.put(pageId, page, false);
    }

    default public void put(PageId pageId, byte[] page, boolean isTemporary) throws ResourceExhaustedException, IOException {
        this.put(pageId, ByteBuffer.wrap(page), isTemporary);
    }

    public void put(PageId var1, ByteBuffer var2, boolean var3) throws ResourceExhaustedException, IOException;

    default public int get(PageId pageId, ReadTargetBuffer buffer) throws IOException, PageNotFoundException {
        return this.get(pageId, 0, (int)buffer.remaining(), buffer, false);
    }

    default public int get(PageId pageId, int pageOffset, int bytesToRead, ReadTargetBuffer buffer) throws IOException, PageNotFoundException {
        return this.get(pageId, pageOffset, bytesToRead, buffer, false);
    }

    public int get(PageId var1, int var2, int var3, ReadTargetBuffer var4, boolean var5) throws IOException, PageNotFoundException;

    default public void delete(PageId pageId, boolean isTemporary) throws IOException, PageNotFoundException {
        this.delete(pageId);
    }

    default public void delete(PageId pageId) throws IOException, PageNotFoundException {
        this.delete(pageId, false);
    }

    default public void commit(String fileId) throws IOException {
        this.commit(fileId, fileId);
    }

    default public void commit(String fileId, String newFileId) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void abort(String fileId) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public DataFileChannel getDataFileChannel(PageId pageId, int pageOffset, int bytesToRead, boolean isTemporary) throws PageNotFoundException {
        throw new UnsupportedOperationException();
    }

    public static final class Metrics {
        public static final Counter CACHE_CLEAN_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CLEAN_ERRORS.getName());
    }
}

