/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.clock.SystemClock;
import alluxio.resource.Pool;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class DynamicResourcePool<T>
implements Pool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicResourcePool.class);
    private final ReentrantLock mLock = new ReentrantLock();
    private final Condition mNotEmpty = this.mLock.newCondition();
    private final int mMaxCapacity;
    private final int mMinCapacity;
    protected final SelectionPolicy mSelectionPolicy;
    @GuardedBy(value="mLock")
    private final Deque<ResourceInternal<T>> mAvailableResources;
    protected final ConcurrentHashMap<T, ResourceInternal<T>> mResources = new ConcurrentHashMap(32);
    private final Counter mCounter;
    private ScheduledExecutorService mExecutor;
    private ScheduledFuture<?> mGcFuture;
    protected Clock mClock = new SystemClock();

    public DynamicResourcePool(Options options) {
        this.mExecutor = Preconditions.checkNotNull(options.getGcExecutor(), "executor");
        this.mCounter = Preconditions.checkNotNull(this.getMetricCounter(), "cannot find resource count metric for %s", (Object)this.getClass().getName());
        this.mMaxCapacity = options.getMaxCapacity();
        this.mMinCapacity = options.getMinCapacity();
        this.mSelectionPolicy = options.getSelectionPolicy();
        this.mAvailableResources = new ArrayDeque<ResourceInternal<T>>(Math.min(this.mMaxCapacity, 32));
        this.mGcFuture = this.mExecutor.scheduleAtFixedRate(() -> {
            ArrayList<Object> resourcesToGc = new ArrayList<Object>();
            try {
                this.mLock.lock();
                if (this.mResources.size() <= this.mMinCapacity) {
                    return;
                }
                int currentSize = this.mResources.size();
                Iterator<ResourceInternal<T>> iterator = this.mAvailableResources.iterator();
                while (iterator.hasNext()) {
                    ResourceInternal<T> next = iterator.next();
                    if (!this.shouldGc(next)) continue;
                    resourcesToGc.add(((ResourceInternal)next).mResource);
                    iterator.remove();
                    this.mResources.remove(((ResourceInternal)next).mResource);
                    this.mCounter.dec();
                    if (--currentSize > this.mMinCapacity) continue;
                    break;
                }
            }
            finally {
                this.mLock.unlock();
            }
            for (Object e : resourcesToGc) {
                LOG.debug("Resource {} is garbage collected.", e);
                try {
                    this.closeResource(e);
                }
                catch (IOException e2) {
                    LOG.warn("Failed to close resource {}.", e, (Object)e2);
                }
            }
        }, options.getInitialDelayMs(), options.getGcIntervalMs(), TimeUnit.MILLISECONDS);
    }

    protected abstract Counter getMetricCounter();

    @Override
    public T acquire() throws IOException {
        try {
            return this.acquire(100L, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public T acquire(long time, TimeUnit unit) throws TimeoutException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void release(T resource) {
        if (!this.mResources.containsKey(resource)) {
            throw new IllegalArgumentException("Resource " + resource.toString() + " was not acquired from this resource pool.");
        }
        ResourceInternal<T> resourceInternal = this.mResources.get(resource);
        resourceInternal.setLastAccessTimeMs(this.mClock.millis());
        try {
            this.mLock.lock();
            this.mAvailableResources.addFirst(resourceInternal);
            this.mNotEmpty.signal();
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.mLock.lock();
            if (this.mAvailableResources.size() != this.mResources.size()) {
                LOG.warn("{} resources are not released when closing the resource pool.", (Object)(this.mResources.size() - this.mAvailableResources.size()));
            }
            for (ResourceInternal<T> resourceInternal : this.mAvailableResources) {
                this.closeResource(((ResourceInternal)resourceInternal).mResource);
            }
            this.mAvailableResources.clear();
        }
        finally {
            this.mLock.unlock();
        }
        this.mGcFuture.cancel(true);
    }

    @Override
    public int size() {
        return this.mResources.size();
    }

    private boolean isFull() {
        return this.mResources.size() >= this.mMaxCapacity;
    }

    private boolean add(ResourceInternal<T> resource) {
        try {
            this.mLock.lock();
            if (this.mResources.size() >= this.mMaxCapacity) {
                boolean bl = false;
                return bl;
            }
            this.mResources.put(((ResourceInternal)resource).mResource, resource);
            this.mCounter.inc();
            boolean bl = true;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void remove(T resource) {
        try {
            this.mLock.lock();
            this.mResources.remove(resource);
            this.mCounter.dec();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private ResourceInternal<T> poll() {
        try {
            this.mLock.lock();
            switch (this.mSelectionPolicy) {
                case FIFO: {
                    ResourceInternal<T> resourceInternal = this.mAvailableResources.pollLast();
                    return resourceInternal;
                }
                case LIFO: {
                    ResourceInternal<T> resourceInternal = this.mAvailableResources.pollFirst();
                    return resourceInternal;
                }
            }
            throw new UnsupportedOperationException("Policy " + (Object)((Object)this.mSelectionPolicy) + " is not supported!");
        }
        finally {
            this.mLock.unlock();
        }
    }

    private T checkHealthyAndRetry(T resource, long endTimeMs) throws TimeoutException, IOException {
        if (this.isHealthy(resource)) {
            return resource;
        }
        LOG.debug("Clearing unhealthy resource {}.", resource);
        this.remove(resource);
        this.closeResource(resource);
        return this.acquire(endTimeMs - this.mClock.millis(), TimeUnit.MILLISECONDS);
    }

    protected abstract boolean shouldGc(ResourceInternal<T> var1);

    protected abstract boolean isHealthy(T var1);

    protected abstract void closeResource(T var1) throws IOException;

    protected abstract T createNewResource() throws IOException;

    public static final class Options {
        private int mMaxCapacity = 1024;
        private int mMinCapacity = 1;
        private long mInitialDelayMs = 100L;
        private long mGcIntervalMs = 120000L;
        private ScheduledExecutorService mGcExecutor;
        private SelectionPolicy mSelectionPolicy = SelectionPolicy.LIFO;

        public int getMaxCapacity() {
            return this.mMaxCapacity;
        }

        public int getMinCapacity() {
            return this.mMinCapacity;
        }

        public long getInitialDelayMs() {
            return this.mInitialDelayMs;
        }

        public long getGcIntervalMs() {
            return this.mGcIntervalMs;
        }

        public ScheduledExecutorService getGcExecutor() {
            return this.mGcExecutor;
        }

        public SelectionPolicy getSelectionPolicy() {
            return this.mSelectionPolicy;
        }

        public Options setSelectionPolicy(SelectionPolicy policy) {
            this.mSelectionPolicy = policy;
            return this;
        }

        public Options setMaxCapacity(int maxCapacity) {
            Preconditions.checkArgument(maxCapacity >= 1);
            this.mMaxCapacity = maxCapacity;
            return this;
        }

        public Options setMinCapacity(int minCapacity) {
            Preconditions.checkArgument(minCapacity >= 0);
            this.mMinCapacity = minCapacity;
            return this;
        }

        public Options setInitialDelayMs(long initialDelayMs) {
            Preconditions.checkArgument(initialDelayMs >= 0L);
            this.mInitialDelayMs = initialDelayMs;
            return this;
        }

        public Options setGcIntervalMs(long gcIntervalMs) {
            Preconditions.checkArgument(gcIntervalMs > 0L);
            this.mGcIntervalMs = gcIntervalMs;
            return this;
        }

        public Options setGcExecutor(ScheduledExecutorService gcExecutor) {
            this.mGcExecutor = gcExecutor;
            return this;
        }

        private Options() {
        }

        public static Options defaultOptions() {
            return new Options();
        }
    }

    protected class ResourceInternal<R> {
        private R mResource;
        private long mLastAccessTimeMs;

        public void setLastAccessTimeMs(long lastAccessTimeMs) {
            this.mLastAccessTimeMs = lastAccessTimeMs;
        }

        public long getLastAccessTimeMs() {
            return this.mLastAccessTimeMs;
        }

        public ResourceInternal(R resource) {
            this.mResource = resource;
            this.mLastAccessTimeMs = DynamicResourcePool.this.mClock.millis();
        }
    }

    public static enum SelectionPolicy {
        FIFO,
        LIFO;

    }
}

