/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.common.collect.ImmutableCollection;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.com.google.inject.internal.ConstructionProxyFactory;
import alluxio.shaded.client.com.google.inject.internal.ConstructorInjector;
import alluxio.shaded.client.com.google.inject.internal.DefaultConstructionProxyFactory;
import alluxio.shaded.client.com.google.inject.internal.Errors;
import alluxio.shaded.client.com.google.inject.internal.ErrorsException;
import alluxio.shaded.client.com.google.inject.internal.FailableCache;
import alluxio.shaded.client.com.google.inject.internal.InjectorImpl;
import alluxio.shaded.client.com.google.inject.internal.InternalFlags;
import alluxio.shaded.client.com.google.inject.internal.MembersInjectorImpl;
import alluxio.shaded.client.com.google.inject.internal.MethodAspect;
import alluxio.shaded.client.com.google.inject.internal.ProxyFactory;
import alluxio.shaded.client.com.google.inject.internal.SingleParameterInjector;
import alluxio.shaded.client.com.google.inject.spi.InjectionPoint;
import alluxio.shaded.client.com.google.inject.spi.InterceptorBinding;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<InterceptorBinding> injectorBindings = this.injector.getBindingData().getInterceptorBindings();
            ImmutableCollection methodAspects = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)Lists.transform(injectorBindings, MethodAspect::fromBinding))).addAll(membersInjector.getAddedAspects())).build();
            factory = new ProxyFactory(injectionPoint, methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

