/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.PositionReader;
import alluxio.file.ReadTargetBuffer;
import java.io.IOException;
import java.io.InputStream;

public abstract class ObjectPositionReader
implements PositionReader {
    protected final String mPath;
    protected final long mFileLength;
    protected final String mBucketName;

    public ObjectPositionReader(String bucketName, String path, long fileLength) {
        this.mBucketName = bucketName;
        this.mPath = path;
        this.mFileLength = fileLength;
    }

    @Override
    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        if (position >= this.mFileLength) {
            return -1;
        }
        int bytesToRead = (int)Math.min(this.mFileLength - position, (long)length);
        try (InputStream in = this.openObjectInputStream(position, bytesToRead);){
            int totalRead;
            int currentRead = 0;
            for (totalRead = 0; totalRead < bytesToRead && (currentRead = buffer.readFromInputStream(in, bytesToRead - totalRead)) >= 0; totalRead += currentRead) {
            }
            int n = totalRead == 0 ? currentRead : totalRead;
            return n;
        }
    }

    protected abstract InputStream openObjectInputStream(long var1, int var3) throws IOException;
}

