/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.swagger.annotations.ApiModelProperty;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.TieredIdentity;
import java.io.Serializable;
import java.util.Arrays;

@NotThreadSafe
public final class WorkerNetAddress
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final WorkerNetAddress DUMMY = new WorkerNetAddress();
    private String mHost = "";
    private String mContainerHost = "";
    private int mRpcPort;
    private int mDataPort;
    private int mSecureRpcPort;
    private int mNettyDataPort;
    private int mWebPort;
    private String mDomainSocketPath = "";
    private TieredIdentity mTieredIdentity;

    public int getSecureRpcPort() {
        return this.mSecureRpcPort;
    }

    @ApiModelProperty(value="Host name of the worker")
    public String getHost() {
        return this.mHost;
    }

    @ApiModelProperty(value="Host name of the physical node if running in a container")
    public String getContainerHost() {
        return this.mContainerHost;
    }

    @ApiModelProperty(value="Port of the worker's Rpc server for metadata operations")
    public int getRpcPort() {
        return this.mRpcPort;
    }

    @ApiModelProperty(value="Port of the worker's server for data operations")
    public int getDataPort() {
        return this.mDataPort;
    }

    @ApiModelProperty(value="Port of the worker's server for netty data operations")
    public int getNettyDataPort() {
        return this.mNettyDataPort;
    }

    @ApiModelProperty(value="Port which exposes the worker's web UI")
    public int getWebPort() {
        return this.mWebPort;
    }

    @ApiModelProperty(value="The domain socket path used by the worker, disabled if empty")
    public String getDomainSocketPath() {
        return this.mDomainSocketPath;
    }

    @ApiModelProperty(value="The worker's tier identity")
    public TieredIdentity getTieredIdentity() {
        if (this.mTieredIdentity != null) {
            return this.mTieredIdentity;
        }
        return new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", this.mHost)));
    }

    public WorkerNetAddress setHost(String host) {
        Preconditions.checkNotNull(host, "host");
        this.mHost = host;
        return this;
    }

    public WorkerNetAddress setContainerHost(String containerHost) {
        Preconditions.checkNotNull(containerHost, "containerHost");
        this.mContainerHost = containerHost;
        return this;
    }

    public WorkerNetAddress setRpcPort(int rpcPort) {
        this.mRpcPort = rpcPort;
        return this;
    }

    public WorkerNetAddress setDataPort(int dataPort) {
        this.mDataPort = dataPort;
        return this;
    }

    public WorkerNetAddress setNettyDataPort(int nettyDataPort) {
        this.mNettyDataPort = nettyDataPort;
        return this;
    }

    public WorkerNetAddress setWebPort(int webPort) {
        this.mWebPort = webPort;
        return this;
    }

    public WorkerNetAddress setSecureRpcPort(int secureRpcPort) {
        this.mSecureRpcPort = secureRpcPort;
        return this;
    }

    public WorkerNetAddress setDomainSocketPath(String domainSocketPath) {
        this.mDomainSocketPath = domainSocketPath;
        return this;
    }

    public WorkerNetAddress setTieredIdentity(TieredIdentity tieredIdentity) {
        this.mTieredIdentity = tieredIdentity;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerNetAddress)) {
            return false;
        }
        WorkerNetAddress that = (WorkerNetAddress)o;
        return this.mHost.equals(that.mHost) && this.mContainerHost.equals(that.mContainerHost) && this.mSecureRpcPort == that.mSecureRpcPort && this.mRpcPort == that.mRpcPort && this.mDataPort == that.mDataPort && this.mWebPort == that.mWebPort && this.mDomainSocketPath.equals(that.mDomainSocketPath) && Objects.equal(this.mTieredIdentity, that.mTieredIdentity);
    }

    public int hashCode() {
        return Objects.hashCode(this.mSecureRpcPort, this.mHost, this.mContainerHost, this.mDataPort, this.mRpcPort, this.mWebPort, this.mDomainSocketPath, this.mTieredIdentity);
    }

    public String dumpMainInfo() {
        return MoreObjects.toStringHelper(this).add("host", this.mHost).add("containerHost", this.mContainerHost).add("rpcPort", this.mRpcPort).add("dataPort", this.mDataPort).add("webPort", this.mWebPort).add("domainSocketPath", this.mDomainSocketPath).toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("host", this.mHost).add("containerHost", this.mContainerHost).add("rpcPort", this.mRpcPort).add("dataPort", this.mDataPort).add("webPort", this.mWebPort).add("domainSocketPath", this.mDomainSocketPath).add("tieredIdentity", this.mTieredIdentity).add("secureRpcPort", this.mSecureRpcPort).toString();
    }
}

