/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.auth;

import alluxio.shaded.client.io.etcd.jetcd.Auth;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

/**
 * AuthRoleGrantPermissionResponse returned by
 * {@link Auth#roleGrantPermission(ByteSequence, ByteSequence, ByteSequence, Permission.Type)} contains a
 * header.
 */
public class AuthRoleGrantPermissionResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse> {

    public AuthRoleGrantPermissionResponse(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionResponse response) {
        super(response, response.getHeader());
    }
}
