/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.op;

import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.Txn;
import alluxio.shaded.client.io.etcd.jetcd.api.Compare;
import alluxio.shaded.client.io.etcd.jetcd.support.Util;

import alluxio.shaded.client.com.google.protobuf.ByteString;

/**
 * The alluxio.shaded.client.com.are predicate in {@link Txn}.
 */
public class Cmp {

    public enum Op {
        EQUAL, GREATER, LESS, NOT_EQUAL
    }

    private final ByteString key;
    private final Op op;
    private final CmpTarget<?> target;

    public Cmp(ByteSequence key, Op alluxio.shaded.client.com.areOp, CmpTarget<?> target) {
        this.key = ByteString.copyFrom(key.getBytes());
        this.op = alluxio.shaded.client.com.areOp;
        this.target = target;
    }

    Compare toCompare(ByteSequence namespace) {
        Compare.Builder alluxio.shaded.client.com.areBuilder = Compare.newBuilder().setKey(Util.prefixNamespace(this.key, namespace));
        switch (this.op) {
            case EQUAL:
                alluxio.shaded.client.com.areBuilder.setResult(Compare.CompareResult.EQUAL);
                break;
            case GREATER:
                alluxio.shaded.client.com.areBuilder.setResult(Compare.CompareResult.GREATER);
                break;
            case LESS:
                alluxio.shaded.client.com.areBuilder.setResult(Compare.CompareResult.LESS);
                break;
            case NOT_EQUAL:
                alluxio.shaded.client.com.areBuilder.setResult(Compare.CompareResult.NOT_EQUAL);
                break;
            default:
                throw new IllegalArgumentException("Unexpected alluxio.shaded.client.com.are type (" + this.op + ")");
        }

        Compare.CompareTarget target = this.target.getTarget();
        Object value = this.target.getTargetValue();

        alluxio.shaded.client.com.areBuilder.setTarget(target);
        switch (target) {
            case VERSION:
                alluxio.shaded.client.com.areBuilder.setVersion((Long) value);
                break;
            case VALUE:
                alluxio.shaded.client.com.areBuilder.setValue((ByteString) value);
                break;
            case MOD:
                alluxio.shaded.client.com.areBuilder.setModRevision((Long) value);
                break;
            case CREATE:
                alluxio.shaded.client.com.areBuilder.setCreateRevision((Long) value);
                break;
            default:
                throw new IllegalArgumentException("Unexpected target type (" + target + ")");
        }

        return alluxio.shaded.client.com.areBuilder.build();
    }
}
