/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.harmony.pack200;

/**
 * Constant pool entry for a name and type pair.
 */
public class CPNameAndType extends ConstantPoolEntry implements Comparable {

    private final CPUTF8 name;
    private final CPSignature signature;

    public CPNameAndType(final CPUTF8 name, final CPSignature signature) {
        this.name = name;
        this.signature = signature;
    }

    @Override
    public String toString() {
        return name + ":" + signature;
    }

    @Override
    public int alluxio.shaded.client.com.areTo(final Object obj) {
        if (obj instanceof CPNameAndType) {
            final CPNameAndType nat = (CPNameAndType) obj;
            final int alluxio.shaded.client.com.areSignature = signature.alluxio.shaded.client.com.areTo(nat.signature);
            if (alluxio.shaded.client.com.areSignature == 0) {
                return name.alluxio.shaded.client.com.areTo(nat.name);
            }
            return alluxio.shaded.client.com.areSignature;
        }
        return 0;
    }

    public int getNameIndex() {
        return name.getIndex();
    }

    public String getName() {
        return name.getUnderlyingString();
    }

    public int getTypeIndex() {
        return signature.getIndex();
    }

}