/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.ConsistentHashProvider;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.ResourceExhaustedException;
import java.util.List;

public class ConsistentHashPolicy
implements WorkerLocationPolicy {
    private static final ConsistentHashProvider HASH_PROVIDER = new ConsistentHashProvider(100, 1000L);
    private final int mNumVirtualNodes;

    public ConsistentHashPolicy(AlluxioConfiguration conf) {
        this.mNumVirtualNodes = conf.getInt(PropertyKey.USER_CONSISTENT_HASH_VIRTUAL_NODE_COUNT);
    }

    @Override
    public List<BlockWorkerInfo> getPreferredWorkers(List<BlockWorkerInfo> blockWorkerInfos, String fileId, int count) throws ResourceExhaustedException {
        if (blockWorkerInfos.size() < count) {
            throw new ResourceExhaustedException(String.format("Not enough workers in the cluster %d workers in the cluster but %d required", blockWorkerInfos.size(), count));
        }
        HASH_PROVIDER.refresh(blockWorkerInfos, this.mNumVirtualNodes);
        List<BlockWorkerInfo> workers = HASH_PROVIDER.getMultiple(fileId, count);
        if (workers.size() != count) {
            throw new ResourceExhaustedException(String.format("Found %d workers from the hash ring but %d required", blockWorkerInfos.size(), count));
        }
        return workers;
    }
}

