/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora.netty;

import alluxio.PositionReader;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.dora.netty.NettyDataReaderStateMachine;
import alluxio.client.file.dora.netty.PartialReadException;
import alluxio.file.ReadTargetBuffer;
import alluxio.proto.dataserver.Protocol;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.function.Supplier;

public class NettyDataReader
implements PositionReader {
    private final FileSystemContext mContext;
    private final WorkerNetAddress mAddress;
    private final Supplier<Protocol.ReadRequest.Builder> mRequestBuilder;

    public NettyDataReader(FileSystemContext context, WorkerNetAddress address, Protocol.ReadRequest.Builder requestBuilder) {
        this.mContext = context;
        this.mAddress = address;
        this.mRequestBuilder = requestBuilder::clone;
    }

    @Override
    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        Protocol.ReadRequest.Builder builder = this.mRequestBuilder.get().setLength(length).setOffset(position).clearCancel();
        NettyDataReaderStateMachine clientStateMachine = new NettyDataReaderStateMachine(this.mContext, this.mAddress, builder, buffer);
        clientStateMachine.run();
        int bytesRead = clientStateMachine.getBytesRead();
        PartialReadException exception = clientStateMachine.getException();
        if (exception != null) {
            throw exception;
        }
        if (bytesRead == 0) {
            return -1;
        }
        return bytesRead;
    }
}

