/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.membership.AlluxioEtcdClient;
import alluxio.shaded.client.io.etcd.jetcd.support.CloseableClient;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
public class ServiceEntity
implements Closeable {
    private CloseableClient mKeepAliveClient;
    AlluxioEtcdClient.Lease mLease;
    protected String mServiceEntityName;
    protected long mRevision;
    public final ReentrantLock mLock = new ReentrantLock();
    public AtomicBoolean mNeedReconnect = new AtomicBoolean(false);

    public ServiceEntity() {
    }

    public ServiceEntity(String serviceEntityName) {
        this.mServiceEntityName = serviceEntityName;
    }

    public String getServiceEntityName() {
        return this.mServiceEntityName;
    }

    public void setKeepAliveClient(CloseableClient keepAliveClient) {
        this.mKeepAliveClient = keepAliveClient;
    }

    public CloseableClient getKeepAliveClient() {
        return this.mKeepAliveClient;
    }

    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.mServiceEntityName);
        dos.writeLong(this.mRevision);
    }

    public void deserialize(DataInputStream dis) throws IOException {
        this.mServiceEntityName = dis.readUTF();
        this.mRevision = dis.readLong();
    }

    @Override
    public void close() throws IOException {
        if (this.mKeepAliveClient != null) {
            this.mKeepAliveClient.close();
        }
    }
}

