/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net;

import alluxio.shaded.client.io.vertx.codegen.annotations.DataObject;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.impl.Arguments;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.json.JsonObject;
import alluxio.shaded.client.io.vertx.core.net.PemTrustOptionsConverter;
import alluxio.shaded.client.io.vertx.core.net.TrustOptions;
import alluxio.shaded.client.io.vertx.core.net.impl.KeyStoreHelper;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@DataObject(generateConverter=true, publicConverter=false)
public class PemTrustOptions
implements TrustOptions,
Cloneable {
    private KeyStoreHelper helper;
    private ArrayList<String> certPaths;
    private ArrayList<Buffer> certValues;

    public PemTrustOptions() {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
    }

    public PemTrustOptions(PemTrustOptions other) {
        this.certPaths = new ArrayList<String>(other.getCertPaths());
        this.certValues = new ArrayList<Buffer>(other.getCertValues());
    }

    public PemTrustOptions(JsonObject json) {
        this();
        PemTrustOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PemTrustOptionsConverter.toJson(this, json);
        return json;
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public PemTrustOptions addCertPath(String certPath) throws NullPointerException {
        Objects.requireNonNull(certPath, "No null certificate accepted");
        Arguments.require(!certPath.isEmpty(), "No empty certificate path accepted");
        this.certPaths.add(certPath);
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public PemTrustOptions addCertValue(Buffer certValue) throws NullPointerException {
        Objects.requireNonNull(certValue, "No null certificate accepted");
        this.certValues.add(certValue);
        return this;
    }

    public KeyStore loadKeyStore(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.store() : null;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getTrustMgrFactory((VertxInternal)vertx) : null;
    }

    @Override
    public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getTrustMgr : null;
    }

    @Override
    public PemTrustOptions copy() {
        return new PemTrustOptions(this);
    }

    KeyStoreHelper getHelper(Vertx vertx) throws Exception {
        if (this.helper == null) {
            Stream<Buffer> certValues = this.certPaths.stream().map(path -> ((VertxInternal)vertx).resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            certValues = Stream.concat(certValues, this.certValues.stream());
            this.helper = new KeyStoreHelper(KeyStoreHelper.loadCA(certValues), null, null);
        }
        return this.helper;
    }
}

