/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.dora;

import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileInfo;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class OpenFileHandle {
    private final String mPath;
    private final FileInfo mInfo;
    private final UUID mUUID;
    private long mPos;
    private long mLastAccessTimeMs;
    private OutputStream mUfsOutStream;
    private boolean mClosed;
    private final CreateFilePOptions mOptions;

    public OpenFileHandle(String path, FileInfo info, CreateFilePOptions options, @Nullable OutputStream ufsOutStream) {
        this.mPath = path;
        this.mInfo = info;
        this.mUUID = UUID.randomUUID();
        this.mUfsOutStream = ufsOutStream;
        this.mPos = 0L;
        this.mLastAccessTimeMs = System.currentTimeMillis();
        this.mClosed = false;
        this.mOptions = options;
    }

    public UUID getUUID() {
        return this.mUUID;
    }

    public long getLastAccessTimeMs() {
        return this.mLastAccessTimeMs;
    }

    public String getPath() {
        return this.mPath;
    }

    public FileInfo getInfo() {
        return this.mInfo;
    }

    public long getPos() {
        return this.mPos;
    }

    public OutputStream getOutStream() {
        return this.mUfsOutStream;
    }

    public CreateFilePOptions getOptions() {
        return this.mOptions;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void close() {
        this.mClosed = true;
        if (this.mUfsOutStream != null) {
            try {
                this.mUfsOutStream.close();
                this.mUfsOutStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

