/*
 * Copyright (C) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.MembersInjector;
import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.Provider;
import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.spi.MembersInjectorLookup;
import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.spi.ProviderLookup;

/**
 * Handles {@code Binder.getProvider} and {@code Binder.getMembersInjector(TypeLiteral)} alluxio.shaded.client.com.ands.
 *
 * @author crazybob@google.alluxio.shaded.client.com.(Bob Lee)
 * @author jessewilson@google.alluxio.shaded.client.com.(Jesse Wilson)
 */
final class LookupProcessor extends AbstractProcessor {

  LookupProcessor(Errors errors) {
    super(errors);
  }

  @Override
  public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
    try {
      MembersInjector<T> membersInjector =
          injector.membersInjectorStore.get(lookup.getType(), errors);
      lookup.initializeDelegate(membersInjector);
      injector.getBindingData().putMembersInjectorLookup(lookup);
    } catch (ErrorsException e) {
      errors.merge(e.getErrors()); // TODO: source
    }

    return true;
  }

  @Override
  public <T> Boolean visit(ProviderLookup<T> lookup) {
    // ensure the provider can be created
    try {
      Provider<T> provider = injector.getProviderOrThrow(lookup.getDependency(), errors);
      lookup.initializeDelegate(provider);
      injector.getBindingData().putProviderLookup(lookup);
    } catch (ErrorsException e) {
      errors.merge(e.getErrors()); // TODO: source
    }

    return true;
  }
}
