/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.http;

import alluxio.shaded.client.io.vertx.codegen.annotations.CacheReturn;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;

/**
 * An HTTP/2 frame.
 *
 * @author <a href="mailto:julien@julienviet.alluxio.shaded.client.com.>Julien Viet</a>
 */
@VertxGen
public interface HttpFrame {

  /**
   * @return the 8-bit type of the frame
   */
  @CacheReturn
  int type();

  /**
   * @return the 8-bit flags specific to the frame
   */
  @CacheReturn
  int flags();

  /**
   * @return the frame payload
   */
  @CacheReturn
  Buffer payload();

}
