package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains policy master service endpoints for Alluxio clients.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/policy_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class PolicyMasterClientServiceGrpc {

  private PolicyMasterClientServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.policy.PolicyMasterClientService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ListPolicyPRequest,
      alluxio.grpc.ListPolicyPResponse> getListPolicyMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListPolicy",
      requestType = alluxio.grpc.ListPolicyPRequest.class,
      responseType = alluxio.grpc.ListPolicyPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ListPolicyPRequest,
      alluxio.grpc.ListPolicyPResponse> getListPolicyMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ListPolicyPRequest, alluxio.grpc.ListPolicyPResponse> getListPolicyMethod;
    if ((getListPolicyMethod = PolicyMasterClientServiceGrpc.getListPolicyMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getListPolicyMethod = PolicyMasterClientServiceGrpc.getListPolicyMethod) == null) {
          PolicyMasterClientServiceGrpc.getListPolicyMethod = getListPolicyMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.ListPolicyPRequest, alluxio.grpc.ListPolicyPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListPolicy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ListPolicyPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ListPolicyPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("ListPolicy"))
              .build();
        }
      }
    }
    return getListPolicyMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.AddPolicyPRequest,
      alluxio.grpc.AddPolicyPResponse> getAddPolicyMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddPolicy",
      requestType = alluxio.grpc.AddPolicyPRequest.class,
      responseType = alluxio.grpc.AddPolicyPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.AddPolicyPRequest,
      alluxio.grpc.AddPolicyPResponse> getAddPolicyMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.AddPolicyPRequest, alluxio.grpc.AddPolicyPResponse> getAddPolicyMethod;
    if ((getAddPolicyMethod = PolicyMasterClientServiceGrpc.getAddPolicyMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getAddPolicyMethod = PolicyMasterClientServiceGrpc.getAddPolicyMethod) == null) {
          PolicyMasterClientServiceGrpc.getAddPolicyMethod = getAddPolicyMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.AddPolicyPRequest, alluxio.grpc.AddPolicyPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddPolicy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.AddPolicyPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.AddPolicyPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("AddPolicy"))
              .build();
        }
      }
    }
    return getAddPolicyMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemovePolicyPRequest,
      alluxio.grpc.RemovePolicyPResponse> getRemovePolicyMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemovePolicy",
      requestType = alluxio.grpc.RemovePolicyPRequest.class,
      responseType = alluxio.grpc.RemovePolicyPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemovePolicyPRequest,
      alluxio.grpc.RemovePolicyPResponse> getRemovePolicyMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemovePolicyPRequest, alluxio.grpc.RemovePolicyPResponse> getRemovePolicyMethod;
    if ((getRemovePolicyMethod = PolicyMasterClientServiceGrpc.getRemovePolicyMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getRemovePolicyMethod = PolicyMasterClientServiceGrpc.getRemovePolicyMethod) == null) {
          PolicyMasterClientServiceGrpc.getRemovePolicyMethod = getRemovePolicyMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.RemovePolicyPRequest, alluxio.grpc.RemovePolicyPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemovePolicy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemovePolicyPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemovePolicyPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("RemovePolicy"))
              .build();
        }
      }
    }
    return getRemovePolicyMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPolicyStatusPRequest,
      alluxio.grpc.GetPolicyStatusPResponse> getGetPolicyStatusMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPolicyStatus",
      requestType = alluxio.grpc.GetPolicyStatusPRequest.class,
      responseType = alluxio.grpc.GetPolicyStatusPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPolicyStatusPRequest,
      alluxio.grpc.GetPolicyStatusPResponse> getGetPolicyStatusMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPolicyStatusPRequest, alluxio.grpc.GetPolicyStatusPResponse> getGetPolicyStatusMethod;
    if ((getGetPolicyStatusMethod = PolicyMasterClientServiceGrpc.getGetPolicyStatusMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getGetPolicyStatusMethod = PolicyMasterClientServiceGrpc.getGetPolicyStatusMethod) == null) {
          PolicyMasterClientServiceGrpc.getGetPolicyStatusMethod = getGetPolicyStatusMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetPolicyStatusPRequest, alluxio.grpc.GetPolicyStatusPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetPolicyStatus"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetPolicyStatusPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetPolicyStatusPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("GetPolicyStatus"))
              .build();
        }
      }
    }
    return getGetPolicyStatusMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetActionInfoRequest,
      alluxio.grpc.GetActionInfoResponse> getGetActionInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetActionInfo",
      requestType = alluxio.grpc.GetActionInfoRequest.class,
      responseType = alluxio.grpc.GetActionInfoResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetActionInfoRequest,
      alluxio.grpc.GetActionInfoResponse> getGetActionInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetActionInfoRequest, alluxio.grpc.GetActionInfoResponse> getGetActionInfoMethod;
    if ((getGetActionInfoMethod = PolicyMasterClientServiceGrpc.getGetActionInfoMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getGetActionInfoMethod = PolicyMasterClientServiceGrpc.getGetActionInfoMethod) == null) {
          PolicyMasterClientServiceGrpc.getGetActionInfoMethod = getGetActionInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetActionInfoRequest, alluxio.grpc.GetActionInfoResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetActionInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetActionInfoRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetActionInfoResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("GetActionInfo"))
              .build();
        }
      }
    }
    return getGetActionInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TriggerPolicyRequest,
      alluxio.grpc.TriggerPolicyResponse> getTriggerPolicyMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "TriggerPolicy",
      requestType = alluxio.grpc.TriggerPolicyRequest.class,
      responseType = alluxio.grpc.TriggerPolicyResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TriggerPolicyRequest,
      alluxio.grpc.TriggerPolicyResponse> getTriggerPolicyMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TriggerPolicyRequest, alluxio.grpc.TriggerPolicyResponse> getTriggerPolicyMethod;
    if ((getTriggerPolicyMethod = PolicyMasterClientServiceGrpc.getTriggerPolicyMethod) == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        if ((getTriggerPolicyMethod = PolicyMasterClientServiceGrpc.getTriggerPolicyMethod) == null) {
          PolicyMasterClientServiceGrpc.getTriggerPolicyMethod = getTriggerPolicyMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.TriggerPolicyRequest, alluxio.grpc.TriggerPolicyResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "TriggerPolicy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.TriggerPolicyRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.TriggerPolicyResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PolicyMasterClientServiceMethodDescriptorSupplier("TriggerPolicy"))
              .build();
        }
      }
    }
    return getTriggerPolicyMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PolicyMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceStub>() {
        @java.lang.Override
        public PolicyMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new PolicyMasterClientServiceStub(channel, callOptions);
        }
      };
    return PolicyMasterClientServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PolicyMasterClientServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceBlockingStub>() {
        @java.lang.Override
        public PolicyMasterClientServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new PolicyMasterClientServiceBlockingStub(channel, callOptions);
        }
      };
    return PolicyMasterClientServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PolicyMasterClientServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<PolicyMasterClientServiceFutureStub>() {
        @java.lang.Override
        public PolicyMasterClientServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new PolicyMasterClientServiceFutureStub(channel, callOptions);
        }
      };
    return PolicyMasterClientServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains policy master service endpoints for Alluxio clients.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Returns the list of policies
     * </pre>
     */
    default void listPolicy(alluxio.grpc.ListPolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ListPolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListPolicyMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Adds a new policy definition
     * </pre>
     */
    default void addPolicy(alluxio.grpc.AddPolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.AddPolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getAddPolicyMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Removes a policy definition
     * </pre>
     */
    default void removePolicy(alluxio.grpc.RemovePolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemovePolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRemovePolicyMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the status of a policy
     * </pre>
     */
    default void getPolicyStatus(alluxio.grpc.GetPolicyStatusPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPolicyStatusPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetPolicyStatusMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the information of a action
     * </pre>
     */
    default void getActionInfo(alluxio.grpc.GetActionInfoRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetActionInfoResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetActionInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Trigger policy scan for all policies
     * </pre>
     */
    default void triggerPolicy(alluxio.grpc.TriggerPolicyRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TriggerPolicyResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTriggerPolicyMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service PolicyMasterClientService.
   * <pre>
   **
   * This interface contains policy master service endpoints for Alluxio clients.
   * </pre>
   */
  public static abstract class PolicyMasterClientServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return PolicyMasterClientServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service PolicyMasterClientService.
   * <pre>
   **
   * This interface contains policy master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class PolicyMasterClientServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<PolicyMasterClientServiceStub> {
    private PolicyMasterClientServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PolicyMasterClientServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new PolicyMasterClientServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the list of policies
     * </pre>
     */
    public void listPolicy(alluxio.grpc.ListPolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ListPolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListPolicyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Adds a new policy definition
     * </pre>
     */
    public void addPolicy(alluxio.grpc.AddPolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.AddPolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getAddPolicyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Removes a policy definition
     * </pre>
     */
    public void removePolicy(alluxio.grpc.RemovePolicyPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemovePolicyPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRemovePolicyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the status of a policy
     * </pre>
     */
    public void getPolicyStatus(alluxio.grpc.GetPolicyStatusPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPolicyStatusPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetPolicyStatusMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the information of a action
     * </pre>
     */
    public void getActionInfo(alluxio.grpc.GetActionInfoRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetActionInfoResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetActionInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Trigger policy scan for all policies
     * </pre>
     */
    public void triggerPolicy(alluxio.grpc.TriggerPolicyRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TriggerPolicyResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTriggerPolicyMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service PolicyMasterClientService.
   * <pre>
   **
   * This interface contains policy master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class PolicyMasterClientServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<PolicyMasterClientServiceBlockingStub> {
    private PolicyMasterClientServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PolicyMasterClientServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new PolicyMasterClientServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the list of policies
     * </pre>
     */
    public alluxio.grpc.ListPolicyPResponse listPolicy(alluxio.grpc.ListPolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListPolicyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Adds a new policy definition
     * </pre>
     */
    public alluxio.grpc.AddPolicyPResponse addPolicy(alluxio.grpc.AddPolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getAddPolicyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Removes a policy definition
     * </pre>
     */
    public alluxio.grpc.RemovePolicyPResponse removePolicy(alluxio.grpc.RemovePolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRemovePolicyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Gets the status of a policy
     * </pre>
     */
    public alluxio.grpc.GetPolicyStatusPResponse getPolicyStatus(alluxio.grpc.GetPolicyStatusPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetPolicyStatusMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Gets the information of a action
     * </pre>
     */
    public alluxio.grpc.GetActionInfoResponse getActionInfo(alluxio.grpc.GetActionInfoRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetActionInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Trigger policy scan for all policies
     * </pre>
     */
    public alluxio.grpc.TriggerPolicyResponse triggerPolicy(alluxio.grpc.TriggerPolicyRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTriggerPolicyMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service PolicyMasterClientService.
   * <pre>
   **
   * This interface contains policy master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class PolicyMasterClientServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<PolicyMasterClientServiceFutureStub> {
    private PolicyMasterClientServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PolicyMasterClientServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new PolicyMasterClientServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the list of policies
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.ListPolicyPResponse> listPolicy(
        alluxio.grpc.ListPolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListPolicyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Adds a new policy definition
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.AddPolicyPResponse> addPolicy(
        alluxio.grpc.AddPolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getAddPolicyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Removes a policy definition
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.RemovePolicyPResponse> removePolicy(
        alluxio.grpc.RemovePolicyPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRemovePolicyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Gets the status of a policy
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetPolicyStatusPResponse> getPolicyStatus(
        alluxio.grpc.GetPolicyStatusPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetPolicyStatusMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Gets the information of a action
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetActionInfoResponse> getActionInfo(
        alluxio.grpc.GetActionInfoRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetActionInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Trigger policy scan for all policies
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.TriggerPolicyResponse> triggerPolicy(
        alluxio.grpc.TriggerPolicyRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTriggerPolicyMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_POLICY = 0;
  private static final int METHODID_ADD_POLICY = 1;
  private static final int METHODID_REMOVE_POLICY = 2;
  private static final int METHODID_GET_POLICY_STATUS = 3;
  private static final int METHODID_GET_ACTION_INFO = 4;
  private static final int METHODID_TRIGGER_POLICY = 5;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_POLICY:
          serviceImpl.listPolicy((alluxio.grpc.ListPolicyPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ListPolicyPResponse>) responseObserver);
          break;
        case METHODID_ADD_POLICY:
          serviceImpl.addPolicy((alluxio.grpc.AddPolicyPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.AddPolicyPResponse>) responseObserver);
          break;
        case METHODID_REMOVE_POLICY:
          serviceImpl.removePolicy((alluxio.grpc.RemovePolicyPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemovePolicyPResponse>) responseObserver);
          break;
        case METHODID_GET_POLICY_STATUS:
          serviceImpl.getPolicyStatus((alluxio.grpc.GetPolicyStatusPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPolicyStatusPResponse>) responseObserver);
          break;
        case METHODID_GET_ACTION_INFO:
          serviceImpl.getActionInfo((alluxio.grpc.GetActionInfoRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetActionInfoResponse>) responseObserver);
          break;
        case METHODID_TRIGGER_POLICY:
          serviceImpl.triggerPolicy((alluxio.grpc.TriggerPolicyRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TriggerPolicyResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getListPolicyMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.ListPolicyPRequest,
              alluxio.grpc.ListPolicyPResponse>(
                service, METHODID_LIST_POLICY)))
        .addMethod(
          getAddPolicyMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.AddPolicyPRequest,
              alluxio.grpc.AddPolicyPResponse>(
                service, METHODID_ADD_POLICY)))
        .addMethod(
          getRemovePolicyMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.RemovePolicyPRequest,
              alluxio.grpc.RemovePolicyPResponse>(
                service, METHODID_REMOVE_POLICY)))
        .addMethod(
          getGetPolicyStatusMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetPolicyStatusPRequest,
              alluxio.grpc.GetPolicyStatusPResponse>(
                service, METHODID_GET_POLICY_STATUS)))
        .addMethod(
          getGetActionInfoMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetActionInfoRequest,
              alluxio.grpc.GetActionInfoResponse>(
                service, METHODID_GET_ACTION_INFO)))
        .addMethod(
          getTriggerPolicyMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.TriggerPolicyRequest,
              alluxio.grpc.TriggerPolicyResponse>(
                service, METHODID_TRIGGER_POLICY)))
        .build();
  }

  private static abstract class PolicyMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PolicyMasterClientServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.PolicyMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PolicyMasterClientService");
    }
  }

  private static final class PolicyMasterClientServiceFileDescriptorSupplier
      extends PolicyMasterClientServiceBaseDescriptorSupplier {
    PolicyMasterClientServiceFileDescriptorSupplier() {}
  }

  private static final class PolicyMasterClientServiceMethodDescriptorSupplier
      extends PolicyMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PolicyMasterClientServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PolicyMasterClientServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PolicyMasterClientServiceFileDescriptorSupplier())
              .addMethod(getListPolicyMethod())
              .addMethod(getAddPolicyMethod())
              .addMethod(getRemovePolicyMethod())
              .addMethod(getGetPolicyStatusMethod())
              .addMethod(getGetActionInfoMethod())
              .addMethod(getTriggerPolicyMethod())
              .build();
        }
      }
    }
    return result;
  }
}
