/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.master.metastore.rocks;

/**
 * DataBlockIndexType used in conjunction with BlockBasedTable.
 * This is a representation of {@link alluxio.shaded.client.org.rocksdb.DataBlockIndexType}
 * added here so core does not depend on RocksDB library.
 * See {@link alluxio.shaded.client.org.rocksdb.DataBlockIndexType} for more information on the values.
 */
public enum DataBlockIndexType {
  kDataBlockBinarySearch,
  kDataBlockBinaryAndHash
}
