/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.maintenance;

import java.net.URI;

import alluxio.shaded.client.io.etcd.jetcd.Maintenance;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

/**
 * StatusResponse returned by {@link Maintenance#statusMember(URI)} contains
 * a header, version, dbSize, current leader, raftIndex, and raftTerm.
 */
public class StatusResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse> {

    public StatusResponse(alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns the cluster protocol version used by the responding member.
     *
     * @return the version.
     */
    public String getVersion() {
        return getResponse().getVersion();
    }

    /**
     * Returns the size of the backend database, in bytes, of the responding member.
     *
     * @return the db sie.
     */
    public long getDbSize() {
        return getResponse().getDbSize();
    }

    /**
     * Returns the member ID which the responding member believes is the current leader.
     *
     * @return the leader.
     */
    public long getLeader() {
        return getResponse().getLeader();
    }

    /**
     * Returns the current raft index of the responding member.
     *
     * @return the raft index.
     */
    public long getRaftIndex() {
        return getResponse().getRaftIndex();
    }

    /**
     * Returns the current raft term of the responding member.
     *
     * @return the raft term.
     */
    public long getRaftTerm() {
        return getResponse().getRaftTerm();
    }
}
