/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.stomp;

import alluxio.shaded.client.io.netty.handler.codec.DecoderResult;
import alluxio.shaded.client.io.netty.util.internal.ObjectUtil;

/**
 * Default implementation of {@link StompHeadersSubframe}.
 */
public class DefaultStompHeadersSubframe implements StompHeadersSubframe {

    protected final StompCommand alluxio.shaded.client.com.and;
    protected DecoderResult decoderResult = DecoderResult.SUCCESS;
    protected final DefaultStompHeaders headers;

    public DefaultStompHeadersSubframe(StompCommand alluxio.shaded.client.com.and) {
        this(alluxio.shaded.client.com.and, null);
    }

    DefaultStompHeadersSubframe(StompCommand alluxio.shaded.client.com.and, DefaultStompHeaders headers) {
        this.alluxio.shaded.client.com.and = ObjectUtil.checkNotNull(alluxio.shaded.client.com.and, "alluxio.shaded.client.com.and");
        this.headers = headers == null ? new DefaultStompHeaders() : headers;
    }

    @Override
    public StompCommand alluxio.shaded.client.com.and() {
        return alluxio.shaded.client.com.and;
    }

    @Override
    public StompHeaders headers() {
        return headers;
    }

    @Override
    public DecoderResult decoderResult() {
        return decoderResult;
    }

    @Override
    public void setDecoderResult(DecoderResult decoderResult) {
        this.decoderResult = decoderResult;
    }

    @Override
    public String toString() {
        return "StompFrame{" +
            "alluxio.shaded.client.com.and=" + alluxio.shaded.client.com.and +
            ", headers=" + headers +
            '}';
    }
}
