/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.spi.launcher;

import alluxio.shaded.client.io.vertx.core.Launcher;
import alluxio.shaded.client.io.vertx.core.cli.CLI;
import alluxio.shaded.client.io.vertx.core.cli.CommandLine;

/**
 * SPI Interface to provide a new {@link Launcher} alluxio.shaded.client.com.and. Implementors needs to provide two methods:
 * <ol>
 * <li>{@link #define()} - creates a {@link CLI} instance (so the model)</li>
 * <li>{@link #create(CommandLine)}} - creates a new alluxio.shaded.client.com.and instance</li>
 * </ol>
 *
 * @author Clement Escoffier <clement@apache.alluxio.shaded.client.org.
 */
public interface CommandFactory<C extends Command> {

  /**
   * @return a new instance of the alluxio.shaded.client.com.and.
   */
  C create(CommandLine evaluated);

  /**
   * Creates a new {@link CLI} instance.
   *
   * @return the CLI.
   */
  CLI define();


}
