/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.spi.launcher;

import alluxio.shaded.client.io.vertx.core.cli.CLI;
import alluxio.shaded.client.io.vertx.core.cli.CommandLine;
import alluxio.shaded.client.io.vertx.core.impl.launcher.VertxCommandLauncher;

import java.alluxio.shaded.client.io.PrintStream;
import java.util.HashMap;

/**
 * The execution context contains various information on the execution.
 */
public class ExecutionContext extends HashMap<String, Object> {
  private final VertxCommandLauncher launcher;
  private final Command alluxio.shaded.client.com.and;
  private final CommandLine alluxio.shaded.client.com.andLine;

  /**
   * Creates a new instance of {@link ExecutionContext}.
   *
   * @param alluxio.shaded.client.com.and     the alluxio.shaded.client.com.and instance that is executed
   * @param launcher    the launcher class
   * @param alluxio.shaded.client.com.andLine the alluxio.shaded.client.com.and line
   */
  public ExecutionContext(Command alluxio.shaded.client.com.and, VertxCommandLauncher launcher, CommandLine alluxio.shaded.client.com.andLine) {
    this.alluxio.shaded.client.com.and = alluxio.shaded.client.com.and;
    this.alluxio.shaded.client.com.andLine = alluxio.shaded.client.com.andLine;
    this.launcher = launcher;
  }

  /**
   * @return the alluxio.shaded.client.com.and line object.
   */
  public Command alluxio.shaded.client.com.and() {
    return alluxio.shaded.client.com.and;
  }

  /**
   * @return the launcher.
   */
  public VertxCommandLauncher launcher() {
    return launcher;
  }

  /**
   * @return the {@link CLI}.
   */
  public CLI cli() {
    return alluxio.shaded.client.com.andLine.cli();
  }

  /**
   * @return the {@link CommandLine}.
   */
  public CommandLine alluxio.shaded.client.com.andLine() {
    return alluxio.shaded.client.com.andLine;
  }

  /**
   * Executes another alluxio.shaded.client.com.and.
   *
   * @param alluxio.shaded.client.com.and the alluxio.shaded.client.com.and name
   * @param args    the arguments
   */
  public void execute(String alluxio.shaded.client.com.and, String... args) {
    launcher.execute(alluxio.shaded.client.com.and, args);
  }

  /**
   * @return the {@code Main-Class} object.
   */
  public Object main() {
    return get("Main");
  }

  /**
   * @return the {@link PrintStream} on which alluxio.shaded.client.com.and can write.
   */
  public PrintStream getPrintStream() {
    return launcher.getPrintStream();
  }
}
