/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.PrefetchCachePolicy;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.collect.EvictingQueue;

public class BasePrefetchCachePolicy
implements PrefetchCachePolicy {
    private int mPrefetchSize = 0;
    private final EvictingQueue<CallTrace> mCallHistory = EvictingQueue.create(Configuration.getInt(PropertyKey.USER_POSITION_READER_STREAMING_MULTIPLIER));

    @Override
    public void addTrace(long pos, int size) {
        this.mCallHistory.add(new CallTrace(pos, size));
        int consecutiveReadLength = 0;
        long lastReadEnd = -1L;
        for (CallTrace trace : this.mCallHistory) {
            if (trace.mPosition == lastReadEnd) {
                lastReadEnd += (long)trace.mLength;
                consecutiveReadLength += trace.mLength;
                continue;
            }
            lastReadEnd = trace.mPosition + (long)trace.mLength;
            consecutiveReadLength = trace.mLength;
        }
        this.mPrefetchSize = consecutiveReadLength;
    }

    @Override
    public void onCacheHitRead() {
    }

    @Override
    public void onCacheMissRead() {
    }

    @Override
    public int getPrefetchSize() {
        return this.mPrefetchSize;
    }

    private static class CallTrace {
        final long mPosition;
        final int mLength;

        private CallTrace(long pos, int length) {
            this.mPosition = pos;
            this.mLength = length;
        }
    }
}

