/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.ReadType;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.DoraFileOutStream;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.ufs.UfsBaseFileSystem;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.JobProgressReportFormat;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.job.JobDescription;
import alluxio.job.JobRequest;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.proto.dataserver.Protocol;
import alluxio.resource.CloseableResource;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
public class DoraCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DoraCacheFileSystem.class);
    public static final int DUMMY_MOUNT_ID = 0;
    private static final Counter UFS_FALLBACK_COUNTER = MetricsSystem.counter(MetricKey.CLIENT_UFS_FALLBACK_COUNT.getName());
    public static DoraCacheFileSystemFactory sDoraCacheFileSystemFactory = new DoraCacheFileSystemFactory();
    private final DoraCacheClient mDoraClient;
    protected final FileSystemContext mFsContext;
    private final boolean mMetadataCacheEnabled;
    private boolean mUfsFallbackEnabled;
    private final long mDefaultVirtualBlockSize;
    private final boolean mClientWriteToUFSEnabled;

    public DoraCacheFileSystem(FileSystem fs, FileSystemContext context) {
        this(fs, context, new DoraCacheClient(context));
    }

    protected DoraCacheFileSystem(FileSystem fs, FileSystemContext context, DoraCacheClient doraCacheClient) {
        super(fs);
        this.mDoraClient = doraCacheClient;
        this.mFsContext = context;
        this.mMetadataCacheEnabled = context.getClusterConf().getBoolean(PropertyKey.DORA_CLIENT_METADATA_CACHE_ENABLED);
        this.mUfsFallbackEnabled = context.getClusterConf().getBoolean(PropertyKey.DORA_CLIENT_UFS_FALLBACK_ENABLED);
        this.mDefaultVirtualBlockSize = context.getClusterConf().getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
        this.mClientWriteToUFSEnabled = context.getClusterConf().getBoolean(PropertyKey.CLIENT_WRITE_TO_UFS_ENABLED);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        LOG.debug("DoraCacheFileSystem getStatus for {}", (Object)ufsFullPath);
        if (!this.mMetadataCacheEnabled) {
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options);
        }
        try {
            GetStatusPOptions mergedOptions = FileSystemOptionsUtils.getStatusDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            URIStatus status = this.mDoraClient.getStatus(ufsFullPath.toString(), mergedOptions);
            FileInfo info = GrpcUtils.fromProto(GrpcUtils.toProto(status.getFileInfo()));
            info.setPath(this.convertToAlluxioPath(new AlluxioURI(info.getUfsPath())).getPath());
            URIStatus statusWithRelativeAlluxioPath = new URIStatus(info, status.getCacheContext());
            return statusWithRelativeAlluxioPath;
        }
        catch (RuntimeException ex) {
            if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                throw new FileDoesNotExistException(ufsFullPath);
            }
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client get status of '{}' error ({} times). Fall back to UFS.", new Object[]{ufsFullPath, UFS_FALLBACK_COUNTER.getCount(), ex});
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options).setFromUFSFallBack();
        }
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        return this.openFile(this.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw new OpenDirectoryException(path);
        }
        if (!status.isCompleted()) {
            throw new FileIncompleteException(path);
        }
        AlluxioConfiguration conf = this.mFsContext.getClusterConf();
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        try {
            if (status.isFromUFSFallBack()) {
                throw new RuntimeException("Status is retrieved from UFS by falling back.");
            }
            Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(mergedOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(mergedOptions.getReadType()).isCache()).setMountId(0L).build();
            return this.mDoraClient.getInStream(status, openUfsBlockOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client open file error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.openFile(status, mergedOptions);
        }
    }

    @Override
    public PositionReader openPositionRead(AlluxioURI path, OpenFilePOptions options) {
        try {
            return this.openPositionRead(this.getStatus(path), options);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from(e);
        }
    }

    @Override
    public PositionReader openPositionRead(URIStatus status, OpenFilePOptions options) {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw AlluxioRuntimeException.from(new OpenDirectoryException(path));
        }
        if (!status.isCompleted()) {
            throw AlluxioRuntimeException.from(new FileIncompleteException(path));
        }
        AlluxioConfiguration conf = this.mFsContext.getClusterConf();
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(mergedOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(mergedOptions.getReadType()).isCache()).setMountId(0L).build();
        return this.mDoraClient.createNettyPositionReader(status, openUfsBlockOptions, this.mUfsFallbackEnabled ? Optional.of(new CloseableSupplier<PositionReader>(() -> this.mDelegatedFileSystem.openPositionRead(status, mergedOptions))) : Optional.empty());
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        ufsFullPath = new AlluxioURI(PathUtils.normalizePath(ufsFullPath.toString(), "/"));
        try {
            ListStatusPOptions mergedOptions = FileSystemOptionsUtils.listStatusDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            List<URIStatus> uriStatuses = this.mDoraClient.listStatus(ufsFullPath.toString(), mergedOptions);
            ArrayList<URIStatus> statusesWithRelativePath = new ArrayList<URIStatus>(uriStatuses.size());
            for (URIStatus s2 : uriStatuses) {
                statusesWithRelativePath.add(new URIStatus(GrpcUtils.fromProto(GrpcUtils.toProto(s2.getFileInfo())).setPath(this.convertToAlluxioPath(new AlluxioURI(s2.getUfsPath())).getPath())));
            }
            return statusesWithRelativePath;
        }
        catch (RuntimeException ex) {
            if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                return Collections.emptyList();
            }
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client list status error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.listStatus(ufsFullPath, options);
        }
    }

    @Override
    public FileOutStream createFile(AlluxioURI alluxioPath, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(alluxioPath);
        try {
            CreateFilePOptions mergedOptions = FileSystemOptionsUtils.createFileDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            Pair<URIStatus, String> result = this.mDoraClient.createFile(ufsFullPath.toString(), mergedOptions);
            URIStatus status = result.getFirst();
            String uuid = result.getSecond();
            LOG.debug("Created file {}, options: {}", (Object)alluxioPath.getPath(), (Object)mergedOptions);
            OutStreamOptions outStreamOptions = new OutStreamOptions(mergedOptions, this.mFsContext, this.mFsContext.getClusterConf());
            outStreamOptions.setUfsPath(status.getUfsPath());
            outStreamOptions.setMountId(status.getMountId());
            outStreamOptions.setAcl(status.getAcl());
            FileOutStream ufsOutStream = this.mClientWriteToUFSEnabled ? this.mDelegatedFileSystem.createFile(ufsFullPath, options) : null;
            DoraFileOutStream doraOutStream = this.mDoraClient.getOutStream(ufsFullPath, this.mFsContext, outStreamOptions, ufsOutStream, uuid);
            return doraOutStream;
        }
        catch (Exception e) {
            if (!this.mUfsFallbackEnabled) {
                throw e;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client CreateFile error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)e);
            return this.mDelegatedFileSystem.createFile(ufsFullPath, options);
        }
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        try {
            CreateDirectoryPOptions mergedOptions = FileSystemOptionsUtils.createDirectoryDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            this.mDoraClient.createDirectory(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client createDirectory error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            this.mDelegatedFileSystem.createDirectory(ufsFullPath, options);
        }
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        try {
            DeletePOptions mergedOptions = FileSystemOptionsUtils.deleteDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            this.mDoraClient.delete(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.debug("Dora client delete error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            this.mDelegatedFileSystem.delete(ufsFullPath, options);
        }
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI srcUfsFullPath = this.convertToUfsPath(src);
        AlluxioURI dstUfsFullPath = this.convertToUfsPath(dst);
        try {
            RenamePOptions mergedOptions = FileSystemOptionsUtils.renameDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            this.mDoraClient.rename(srcUfsFullPath.toString(), dstUfsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client rename error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            this.mDelegatedFileSystem.rename(srcUfsFullPath, dstUfsFullPath, options);
        }
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.listStatus(path, options).forEach(action);
    }

    @Override
    public boolean exists(AlluxioURI path, ExistsPOptions options) throws InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        try {
            ExistsPOptions mergedOptions = FileSystemOptionsUtils.existsDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            return this.mDoraClient.exists(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client exists error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.exists(ufsFullPath, options);
        }
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        try {
            SetAttributePOptions mergedOptions = FileSystemOptionsUtils.setAttributeDefaults(this.mFsContext.getClusterConf()).toBuilder().mergeFrom(options).build();
            this.mDoraClient.setAttribute(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (!this.mUfsFallbackEnabled) {
                throw ex;
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.error("Dora client setAttribute error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            this.mDelegatedFileSystem.setAttribute(ufsFullPath, options);
        }
    }

    public AlluxioURI convertToUfsPath(AlluxioURI alluxioPath) {
        Preconditions.checkArgument(this.mDelegatedFileSystem instanceof UfsBaseFileSystem, "FileSystem is not UfsBaseFileSystem");
        UfsBaseFileSystem under = (UfsBaseFileSystem)this.mDelegatedFileSystem;
        AlluxioURI rootUFS = under.getRootUFS();
        return PathUtils.convertAlluxioPathToUfsPath(alluxioPath, rootUFS);
    }

    public AlluxioURI convertToAlluxioPath(AlluxioURI ufsPath) throws InvalidPathException {
        Preconditions.checkArgument(this.mDelegatedFileSystem instanceof UfsBaseFileSystem, "FileSystem is not UfsBaseFileSystem");
        AlluxioURI rootUfs = ((UfsBaseFileSystem)this.mDelegatedFileSystem).getRootUFS();
        return PathUtils.convertUfsPathToAlluxioPath(ufsPath, rootUfs);
    }

    public WorkerNetAddress getWorkerNetAddress(AlluxioURI path) {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        return this.mDoraClient.getWorkerNetAddress(ufsFullPath.toString());
    }

    public Map<String, List<WorkerNetAddress>> checkFileLocation(AlluxioURI path) throws IOException {
        return this.checkFileLocation(path, GetStatusPOptions.getDefaultInstance());
    }

    public Map<String, List<WorkerNetAddress>> checkFileLocation(AlluxioURI path, GetStatusPOptions options) throws IOException {
        AlluxioURI ufsFullPath = this.convertToUfsPath(path);
        return this.mDoraClient.checkFileLocation(ufsFullPath.toString(), options);
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) throws IOException, AlluxioException {
        AlluxioURI ufsPath = this.convertToUfsPath(path);
        URIStatus status = this.mDoraClient.getStatus(ufsPath.toString(), FileSystemOptionsUtils.getStatusDefaults(this.mFsContext.getClusterConf()));
        return this.getBlockLocations(status);
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(URIStatus status) throws IOException, AlluxioException {
        AlluxioURI ufsPath = this.convertToUfsPath(new AlluxioURI(status.getUfsPath()));
        WorkerNetAddress workerNetAddress = this.mDoraClient.getWorkerNetAddress(ufsPath.toString());
        long blockSize = this.mDefaultVirtualBlockSize;
        long length = status.getLength();
        int blockNum = length == blockSize ? 1 : (int)(length / blockSize) + 1;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < blockNum; ++i) {
            long offset = (long)i * blockSize;
            BlockLocation blockLocation = new BlockLocation().setWorkerAddress(workerNetAddress);
            BlockInfo bi = new BlockInfo().setBlockId(i + 1).setLength(Math.min(blockSize, status.getLength() - offset)).setLocations(ImmutableList.of(blockLocation));
            FileBlockInfo fbi = new FileBlockInfo().setUfsLocations(ImmutableList.of(ufsPath.toString())).setBlockInfo(bi).setOffset(offset);
            BlockLocationInfo blockLocationInfo = new BlockLocationInfo(fbi, ImmutableList.of(workerNetAddress));
            listBuilder.add(blockLocationInfo);
        }
        return listBuilder.build();
    }

    public void setUfsFallbackEnabled(boolean enabled) {
        this.mUfsFallbackEnabled = enabled;
    }

    @Override
    @Nullable
    public DoraCacheFileSystem getDoraCacheFileSystem() {
        return this;
    }

    @Override
    public Optional<String> submitJob(JobRequest jobRequest) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            Optional<String> optional = client.get().submitJob(jobRequest);
            return optional;
        }
    }

    @Override
    public boolean stopJob(JobDescription jobDescription) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            boolean bl = client.get().stopJob(jobDescription);
            return bl;
        }
    }

    @Override
    public String getJobProgress(JobDescription jobDescription, JobProgressReportFormat format, boolean verbose) {
        try (CloseableResource<FileSystemMasterClient> client = this.mFsContext.acquireMasterClientResource();){
            String string = client.get().getJobProgress(jobDescription, format, verbose);
            return string;
        }
    }

    public static class DoraCacheFileSystemFactory {
        public DoraCacheFileSystem createAnInstance(FileSystem fs, FileSystemContext context) {
            return new DoraCacheFileSystem(fs, context);
        }
    }
}

