/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.github.oxo42.stateless4j;

import alluxio.shaded.client.com.github.oxo42.stateless4j.delegates.Action1;
import alluxio.shaded.client.com.github.oxo42.stateless4j.delegates.Action2;
import alluxio.shaded.client.com.github.oxo42.stateless4j.transitions.Transition;
import alluxio.shaded.client.com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StateRepresentation<S, T> {
    private static final String ACTION_IS_NULL = "action is null";
    private static final String TRANSITION_IS_NULL = "transition is null";
    private final S state;
    private final Map<T, List<TriggerBehaviour<S, T>>> triggerBehaviours = new HashMap<T, List<TriggerBehaviour<S, T>>>();
    private final List<Action2<Transition<S, T>, Object[]>> entryActions = new ArrayList<Action2<Transition<S, T>, Object[]>>();
    private final List<Action1<Transition<S, T>>> exitActions = new ArrayList<Action1<Transition<S, T>>>();
    private final List<StateRepresentation<S, T>> substates = new ArrayList<StateRepresentation<S, T>>();
    private StateRepresentation<S, T> superstate;

    public StateRepresentation(S state) {
        this.state = state;
    }

    protected Map<T, List<TriggerBehaviour<S, T>>> getTriggerBehaviours() {
        return this.triggerBehaviours;
    }

    public Boolean canHandle(T trigger) {
        return this.tryFindHandler(trigger) != null;
    }

    public TriggerBehaviour<S, T> tryFindHandler(T trigger) {
        TriggerBehaviour<S, T> result = this.tryFindLocalHandler(trigger);
        if (result == null && this.superstate != null) {
            result = this.superstate.tryFindHandler(trigger);
        }
        return result;
    }

    TriggerBehaviour<S, T> tryFindLocalHandler(T trigger) {
        List<TriggerBehaviour<S, T>> possible = this.triggerBehaviours.get(trigger);
        if (possible == null) {
            return null;
        }
        ArrayList<TriggerBehaviour<S, T>> actual = new ArrayList<TriggerBehaviour<S, T>>();
        for (TriggerBehaviour<S, T> triggerBehaviour : possible) {
            if (!triggerBehaviour.isGuardConditionMet()) continue;
            actual.add(triggerBehaviour);
        }
        if (actual.size() > 1) {
            throw new IllegalStateException("Multiple permitted exit transitions are configured from state '" + this.state + "' for trigger '" + trigger + "'. Guard clauses must be mutually exclusive.");
        }
        return actual.isEmpty() ? null : (TriggerBehaviour)actual.get(0);
    }

    public void addEntryAction(final T trigger, final Action2<Transition<S, T>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] args) {
                Object trans_trigger = t.getTrigger();
                if (trans_trigger != null && trans_trigger.equals(trigger)) {
                    action.doIt(t, args);
                }
            }
        });
    }

    public void addEntryAction(Action2<Transition<S, T>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(action);
    }

    public void insertEntryAction(Action2<Transition<S, T>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(0, action);
    }

    public void addExitAction(Action1<Transition<S, T>> action) {
        assert (action != null) : "action is null";
        this.exitActions.add(action);
    }

    public void enter(Transition<S, T> transition, Object ... entryArgs) {
        assert (transition != null) : "transition is null";
        if (transition.isReentry()) {
            this.executeEntryActions(transition, entryArgs);
        } else if (!this.includes(transition.getSource())) {
            if (this.superstate != null) {
                this.superstate.enter(transition, entryArgs);
            }
            this.executeEntryActions(transition, entryArgs);
        }
    }

    public void exit(Transition<S, T> transition) {
        assert (transition != null) : "transition is null";
        if (transition.isReentry()) {
            this.executeExitActions(transition);
        } else if (!this.includes(transition.getDestination())) {
            this.executeExitActions(transition);
            if (this.superstate != null) {
                this.superstate.exit(transition);
            }
        }
    }

    void executeEntryActions(Transition<S, T> transition, Object[] entryArgs) {
        assert (transition != null) : "transition is null";
        assert (entryArgs != null) : "entryArgs is null";
        for (Action2<Transition<S, Transition<S, T>>, Object[]> action2 : this.entryActions) {
            action2.doIt(transition, entryArgs);
        }
    }

    void executeExitActions(Transition<S, T> transition) {
        assert (transition != null) : "transition is null";
        for (Action1<Transition<S, Transition<S, T>>> action1 : this.exitActions) {
            action1.doIt(transition);
        }
    }

    public void addTriggerBehaviour(TriggerBehaviour<S, T> triggerBehaviour) {
        List<Object> allowed;
        if (!this.triggerBehaviours.containsKey(triggerBehaviour.getTrigger())) {
            allowed = new ArrayList();
            this.triggerBehaviours.put(triggerBehaviour.getTrigger(), allowed);
        }
        allowed = this.triggerBehaviours.get(triggerBehaviour.getTrigger());
        allowed.add(triggerBehaviour);
    }

    public StateRepresentation<S, T> getSuperstate() {
        return this.superstate;
    }

    public void setSuperstate(StateRepresentation<S, T> value) {
        this.superstate = value;
    }

    public S getUnderlyingState() {
        return this.state;
    }

    public void addSubstate(StateRepresentation<S, T> substate) {
        assert (substate != null) : "substate is null";
        this.substates.add(substate);
    }

    public boolean includes(S stateToCheck) {
        for (StateRepresentation<S, T> s2 : this.substates) {
            if (!s2.includes(stateToCheck)) continue;
            return true;
        }
        return this.state.equals(stateToCheck);
    }

    public boolean isIncludedIn(S stateToCheck) {
        return this.state.equals(stateToCheck) || this.superstate != null && this.superstate.isIncludedIn(stateToCheck);
    }

    public List<T> getPermittedTriggers() {
        HashSet<T> result = new HashSet<T>();
        block0: for (T t : this.triggerBehaviours.keySet()) {
            for (TriggerBehaviour<S, T> v : this.triggerBehaviours.get(t)) {
                if (!v.isGuardConditionMet()) continue;
                result.add(t);
                continue block0;
            }
        }
        if (this.getSuperstate() != null) {
            result.addAll(this.getSuperstate().getPermittedTriggers());
        }
        return new ArrayList(result);
    }
}

