/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.resolver;

import alluxio.shaded.client.com.google.common.base.Splitter;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import alluxio.shaded.client.io.etcd.jetcd.resolver.AbstractNameResolver;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;

public class DnsSrvNameResolver
extends AbstractNameResolver {
    public static final String SCHEME = "dns+srv";
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();

    public DnsSrvNameResolver(URI targetUri) {
        super(targetUri);
    }

    @Override
    protected List<EquivalentAddressGroup> computeAddressGroups() {
        ArrayList<EquivalentAddressGroup> groups = new ArrayList<EquivalentAddressGroup>();
        for (SocketAddress address : this.resolveAddresses()) {
            groups.add(new EquivalentAddressGroup(address, Attributes.EMPTY));
        }
        return groups;
    }

    private List<SocketAddress> resolveAddresses() {
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        try {
            String address = this.getTargetUri().getPath();
            if (address.startsWith("/")) {
                address = address.substring(1);
            }
            InitialDirContext ctx = new InitialDirContext(ENV);
            javax.naming.directory.Attributes attributes = ctx.getAttributes(address, ATTRIBUTE_IDS);
            NamingEnumeration<?> resolved = attributes.get("srv").getAll();
            while (resolved.hasMore()) {
                String record = (String)resolved.next();
                List<String> split = Splitter.on(' ').splitToList(record);
                if (split.size() < 4) continue;
                String host = split.get(3).trim();
                String port = split.get(2).trim();
                addresses.add(new InetSocketAddress(host, Integer.parseInt(port)));
            }
        }
        catch (Exception e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
        return addresses;
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

