/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class IsolatingClassLoader
extends URLClassLoader {
    private volatile boolean closed;
    private List<String> isolatedClasses;

    public IsolatingClassLoader(URL[] urls, ClassLoader parent, List<String> isolatedClasses) {
        super(urls, parent);
        this.isolatedClasses = isolatedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (this.isIsolatedClass(name)) {
                    if (this.isVertxOrSystemClass(name)) {
                        try {
                            c = this.getParent().loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        try {
                            c = this.findClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            c = this.getParent().loadClass(name);
                        }
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                } else {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }

    private boolean isIsolatedClass(String name) {
        if (this.isolatedClasses != null) {
            for (String isolated : this.isolatedClasses) {
                if (isolated.endsWith(".*")) {
                    String isolatedPackage = isolated.substring(0, isolated.length() - 1);
                    String paramPackage = name.substring(0, name.lastIndexOf(46) + 1);
                    if (!paramPackage.startsWith(isolatedPackage)) continue;
                    return true;
                }
                if (!isolated.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentResources;
        ArrayList<URL> resources = Collections.list(this.findResources(name));
        if (this.getParent() != null && (parentResources = this.getParent().getResources(name)).hasMoreElements()) {
            resources.addAll(Collections.list(parentResources));
        }
        return Collections.enumeration(resources);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private boolean isVertxOrSystemClass(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.*") || name.startsWith("alluxio.shaded.client.com.sun.") || name.startsWith("alluxio.shaded.client.io.vertx.core") || name.startsWith("alluxio.shaded.client.io.netty.") || name.startsWith("alluxio.shaded.client.com.fasterxml.jackson");
    }
}

