/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net;

import alluxio.shaded.client.io.vertx.codegen.annotations.CacheReturn;
import alluxio.shaded.client.io.vertx.codegen.annotations.Fluent;
import alluxio.shaded.client.io.vertx.codegen.annotations.GenIgnore;
import alluxio.shaded.client.io.vertx.codegen.annotations.Nullable;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;
import alluxio.shaded.client.io.vertx.core.streams.ReadStream;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

@VertxGen
public interface NetSocket
extends ReadStream<Buffer>,
WriteStream<Buffer> {
    @Override
    public NetSocket exceptionHandler(Handler<Throwable> var1);

    public NetSocket handler(Handler<Buffer> var1);

    public NetSocket pause();

    public NetSocket resume();

    public NetSocket fetch(long var1);

    public NetSocket endHandler(Handler<Void> var1);

    public NetSocket setWriteQueueMaxSize(int var1);

    public NetSocket drainHandler(Handler<Void> var1);

    public String writeHandlerID();

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> write(String var1);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> write(String var1, String var2);

    @Override
    public void write(Buffer var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> sendFile(String filename) {
        return this.sendFile(filename, 0L, Long.MAX_VALUE);
    }

    default public Future<Void> sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    public Future<Void> sendFile(String var1, long var2, long var4);

    @Fluent
    default public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, 0L, Long.MAX_VALUE, resultHandler);
    }

    @Fluent
    default public NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, offset, Long.MAX_VALUE, resultHandler);
    }

    @Fluent
    public NetSocket sendFile(String var1, long var2, long var4, Handler<AsyncResult<Void>> var6);

    @CacheReturn
    public SocketAddress remoteAddress();

    public SocketAddress remoteAddress(boolean var1);

    @CacheReturn
    public SocketAddress localAddress();

    public SocketAddress localAddress(boolean var1);

    @Override
    public Future<Void> end();

    @Override
    public void end(Handler<AsyncResult<Void>> var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    @Fluent
    public NetSocket closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> var1);

    public Future<Void> upgradeToSsl();

    @Fluent
    public NetSocket upgradeToSsl(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> upgradeToSsl(String var1);

    public boolean isSsl();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @Deprecated
    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException;

    public String indicatedServerName();

    public String applicationLayerProtocol();
}

